/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.target;

import java.io.File;
import java.net.InetAddress;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jscsi.target.Configuration;
import org.jscsi.target.TargetServer;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator
implements BundleActivator {
    private ExecutorService runner;
    private TargetServer target;

    public void start(BundleContext context) throws Exception {
        System.out.println("Starting up jscsi bundle");
        String pIp = context.getProperty("jscsi_target-published_ip");
        InetAddress addr = InetAddress.getByName(pIp);
        if (addr == null) {
            throw new IllegalArgumentException("Either the address provided with 'jscsi_target-published_ip' is illegal or not contained within the available network interfaces.");
        }
        File schemaFile = new File("jscsi-target.xsd");
        if (!schemaFile.exists()) {
            Files.copy(context.getBundle().getResource("/jscsi-target.xsd").openStream(), schemaFile.toPath(), new CopyOption[0]);
        }
        System.out.println("Schemafile: " + (schemaFile.exists() ? "exists" : "does not exist"));
        File configFile = new File("jscsi-target.xml");
        if (!configFile.exists()) {
            Files.copy(context.getBundle().getResource("/jscsi-target.xml").openStream(), configFile.toPath(), new CopyOption[0]);
        }
        System.out.println("Configfile: " + (configFile.exists() ? "exists" : "does not exist"));
        this.target = new TargetServer(Configuration.create(schemaFile, configFile, addr.getHostAddress()));
        this.runner = Executors.newSingleThreadExecutor();
        this.runner.submit(this.target);
    }

    public void stop(BundleContext context) throws Exception {
        this.runner.shutdown();
    }
}

