/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.target;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.jscsi.target.Target;
import org.jscsi.target.scsi.lun.LogicalUnitNumber;
import org.jscsi.target.storage.IStorageModule;
import org.jscsi.target.storage.JCloudsStorageModule;
import org.jscsi.target.storage.RandomAccessStorageModule;
import org.jscsi.target.storage.SynchronizedRandomAccessStorageModule;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class Configuration {
    public static final String ELEMENT_TARGET_LIST = "TargetList";
    public static final String ELEMENT_TARGET = "Target";
    public static final String ELEMENT_SYNCFILESTORAGE = "SyncFileStorage";
    public static final String ELEMENT_ASYNCFILESTORAGE = "AsyncFileStorage";
    public static final String ELEMENT_JCLOUDSSTORAGE = "JCloudsStorage";
    public static final String ELEMENT_FILESTORAGE = "FileStorage";
    public static final String ELEMENT_CREATE = "Create";
    public static final String ATTRIBUTE_SIZE = "size";
    public static final String ELEMENT_ALLOWSLOPPYNEGOTIATION = "AllowSloppyNegotiation";
    public static final String ELEMENT_PORT = "Port";
    private static final File CONFIG_DIR = new File("src" + File.separator + "main" + File.separator + "resources" + File.separator);
    public static final File CONFIGURATION_SCHEMA_FILE = new File(CONFIG_DIR, "jscsi-target.xsd");
    public static final File CONFIGURATION_CONFIG_FILE = new File(CONFIG_DIR, "jscsi-target.xml");
    protected final List<Target> targets;
    protected String targetAddress;
    protected int port = 3260;
    protected boolean allowSloppyNegotiation;
    protected final int targetPortalGroupTag = 1;
    protected final LogicalUnitNumber logicalUnitNumber = new LogicalUnitNumber(0L);
    protected final int outMaxRecvDataSegmentLength = 8192;
    private final int maxRecvTextPduSequenceLength = 4;

    public Configuration(String pTargetAddress) throws IOException {
        this.targetAddress = pTargetAddress.equals("") ? InetAddress.getLocalHost().getHostAddress() : pTargetAddress;
        this.targets = new ArrayList<Target>();
    }

    public int getInMaxRecvTextPduSequenceLength() {
        return 4;
    }

    public int getOutMaxRecvDataSegmentLength() {
        return 8192;
    }

    public String getTargetAddress() {
        return this.targetAddress;
    }

    public int getPort() {
        return this.port;
    }

    public boolean getAllowSloppyNegotiation() {
        return this.allowSloppyNegotiation;
    }

    public int getTargetPortalGroupTag() {
        return 1;
    }

    public LogicalUnitNumber getLogicalUnitNumber() {
        return this.logicalUnitNumber;
    }

    public List<Target> getTargets() {
        return this.targets;
    }

    public static Configuration create(String pTargetAddress) throws SAXException, ParserConfigurationException, IOException {
        return Configuration.create(CONFIGURATION_SCHEMA_FILE, CONFIGURATION_CONFIG_FILE, pTargetAddress);
    }

    public static Configuration create(File schemaLocation, File configFile, String pTargetAddress) throws SAXException, ParserConfigurationException, IOException {
        return Configuration.create(new FileInputStream(schemaLocation), new FileInputStream(configFile), pTargetAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Configuration create(InputStream schemaLocation, InputStream configFile, String pTargetAddress) throws SAXException, ParserConfigurationException, IOException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(new StreamSource(schemaLocation));
        Validator validator = schema.newValidator();
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        domFactory.setNamespaceAware(true);
        DocumentBuilder builder = domFactory.newDocumentBuilder();
        Document doc = builder.parse(configFile);
        DOMSource source = new DOMSource(doc);
        DOMResult result = new DOMResult();
        validator.validate(source, result);
        Document root = (Document)result.getNode();
        Configuration returnConfiguration = new Configuration(pTargetAddress);
        Element targetListNode = (Element)root.getElementsByTagName(ELEMENT_TARGET_LIST).item(0);
        NodeList targetList = targetListNode.getElementsByTagName(ELEMENT_TARGET);
        for (int curTargetNum = 0; curTargetNum < targetList.getLength(); ++curTargetNum) {
            Target curTargetInfo = Configuration.parseTargetElement((Element)targetList.item(curTargetNum));
            List<Target> list = returnConfiguration.targets;
            synchronized (list) {
                returnConfiguration.targets.add(curTargetInfo);
                continue;
            }
        }
        returnConfiguration.port = root.getElementsByTagName(ELEMENT_PORT).getLength() > 0 ? Integer.parseInt(root.getElementsByTagName(ELEMENT_PORT).item(0).getTextContent()) : 3260;
        Node allowSloppyNegotiationNode = root.getElementsByTagName(ELEMENT_ALLOWSLOPPYNEGOTIATION).item(0);
        returnConfiguration.allowSloppyNegotiation = allowSloppyNegotiationNode == null ? false : Boolean.parseBoolean(allowSloppyNegotiationNode.getTextContent());
        return returnConfiguration;
    }

    protected static Target parseTargetElement(Element targetElement) throws IOException {
        long storageLength;
        Node nextNode = Configuration.chopWhiteSpaces(targetElement.getFirstChild());
        String targetName = nextNode.getTextContent();
        nextNode = Configuration.chopWhiteSpaces(nextNode.getNextSibling());
        String targetAlias = "";
        if (nextNode.getLocalName().equals("TargetAlias")) {
            targetAlias = nextNode.getTextContent();
            nextNode = Configuration.chopWhiteSpaces(nextNode.getNextSibling());
        }
        Class kind = null;
        switch (nextNode.getLocalName()) {
            case "SyncFileStorage": {
                kind = SynchronizedRandomAccessStorageModule.class;
                break;
            }
            case "AsyncFileStorage": {
                kind = RandomAccessStorageModule.class;
                break;
            }
            case "JCloudsStorage": {
                kind = JCloudsStorageModule.class;
            }
        }
        nextNode = nextNode.getFirstChild();
        nextNode = Configuration.chopWhiteSpaces(nextNode);
        String storageFilePath = nextNode.getTextContent();
        nextNode = Configuration.chopWhiteSpaces(nextNode.getNextSibling());
        boolean create = true;
        if (nextNode.getLocalName().equals(ELEMENT_CREATE)) {
            Node sizeAttribute = nextNode.getAttributes().getNamedItem(ATTRIBUTE_SIZE);
            storageLength = Math.round(Double.valueOf(sizeAttribute.getTextContent()) * Math.pow(1024.0, 3.0));
        } else {
            storageLength = new File(storageFilePath).length();
            create = false;
        }
        IStorageModule module = RandomAccessStorageModule.open(new File(storageFilePath), storageLength, create, kind);
        return new Target(targetName, targetAlias, module);
    }

    protected static Node chopWhiteSpaces(Node node) {
        Node toIterate = node;
        while (toIterate instanceof Text && toIterate.getTextContent().trim().length() == 0) {
            toIterate = toIterate.getNextSibling();
        }
        return toIterate;
    }
}

