/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.target;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.security.DigestException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.jscsi.exception.InternetSCSIException;
import org.jscsi.parser.OperationCode;
import org.jscsi.parser.ProtocolDataUnit;
import org.jscsi.parser.login.ISID;
import org.jscsi.parser.login.LoginRequestParser;
import org.jscsi.target.Configuration;
import org.jscsi.target.Target;
import org.jscsi.target.connection.Connection;
import org.jscsi.target.connection.TargetSession;
import org.jscsi.target.scsi.inquiry.DeviceIdentificationVpdPage;
import org.jscsi.target.settings.SettingsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TargetServer
implements Callable<Void> {
    protected static final Logger LOGGER = LoggerFactory.getLogger(TargetServer.class);
    private ServerSocketChannel serverSocketChannel;
    private Collection<TargetSession> sessions = new Vector<TargetSession>();
    private Configuration config;
    private DeviceIdentificationVpdPage deviceIdentificationVpdPage;
    protected HashMap<String, Target> targets = new HashMap();
    private final ExecutorService workerPool;
    private static final AtomicInteger nextTargetTransferTag = new AtomicInteger();
    private boolean running = true;

    public TargetServer(Configuration conf) {
        this.config = conf;
        LOGGER.debug("Starting jSCSI-target: ");
        LOGGER.debug("   port:           " + this.getConfig().getPort());
        LOGGER.debug("   loading targets.");
        List<Target> targetInfo = this.getConfig().getTargets();
        for (Target curTargetInfo : targetInfo) {
            this.targets.put(curTargetInfo.getTargetName(), curTargetInfo);
            LOGGER.debug("   target name:    " + curTargetInfo.getTargetName() + " loaded.");
        }
        this.deviceIdentificationVpdPage = new DeviceIdentificationVpdPage(this);
        this.workerPool = Executors.newCachedThreadPool();
    }

    public static int getNextTargetTransferTag() {
        int tag;
        while ((tag = nextTargetTransferTag.getAndIncrement()) == -1) {
        }
        return tag;
    }

    public static void main(String[] args) throws Exception {
        TargetServer target;
        System.out.println("This system provides more than one IP Address to advertise.\n");
        Enumeration<NetworkInterface> interfaceEnum = NetworkInterface.getNetworkInterfaces();
        int addressCounter = 0;
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
        while (interfaceEnum.hasMoreElements()) {
            NetworkInterface i = interfaceEnum.nextElement();
            Enumeration<InetAddress> addressEnum = i.getInetAddresses();
            while (addressEnum.hasMoreElements()) {
                InetAddress address = addressEnum.nextElement();
                System.out.println("[" + addressCounter + "] " + address.getHostAddress());
                addresses.add(address);
                ++addressCounter;
            }
        }
        System.out.print("\nWhich one should be used?\nType in the number: ");
        Integer chosenIndex = null;
        while (chosenIndex == null) {
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            String line = br.readLine();
            try {
                chosenIndex = Integer.parseInt(line);
            }
            catch (NumberFormatException nfe) {
                chosenIndex = null;
            }
        }
        String targetAddress = ((InetAddress)addresses.get(chosenIndex)).getHostAddress();
        System.out.println("Using ip address " + ((InetAddress)addresses.get(chosenIndex)).getHostAddress());
        switch (args.length) {
            case 0: {
                target = new TargetServer(Configuration.create(targetAddress));
                break;
            }
            case 1: {
                target = new TargetServer(Configuration.create(Configuration.CONFIGURATION_SCHEMA_FILE.exists() ? new FileInputStream(Configuration.CONFIGURATION_SCHEMA_FILE) : TargetServer.class.getResourceAsStream("/jscsi-target.xsd"), new FileInputStream(args[0]), targetAddress));
                break;
            }
            case 2: {
                target = new TargetServer(Configuration.create(new File(args[0]), new File(args[1]), targetAddress));
                break;
            }
            default: {
                throw new IllegalArgumentException("Only zero or one Parameter (Path to Configuration-File) allowed!");
            }
        }
        target.call();
    }

    @Override
    public Void call() throws Exception {
        try {
            this.serverSocketChannel = ServerSocketChannel.open();
            this.serverSocketChannel.configureBlocking(true);
            this.serverSocketChannel.socket().bind(new InetSocketAddress(this.getConfig().getTargetAddress(), this.getConfig().getPort()));
            while (this.running) {
                SocketChannel socketChannel = this.serverSocketChannel.accept();
                socketChannel.socket().setTcpNoDelay(true);
                Connection.TargetConnection newConnection = new Connection.TargetConnection(socketChannel, true);
                try {
                    ProtocolDataUnit pdu = newConnection.receivePdu();
                    if (pdu.getBasicHeaderSegment().getOpCode() != OperationCode.LOGIN_REQUEST) {
                        throw new InternetSCSIException();
                    }
                    LoginRequestParser parser = (LoginRequestParser)pdu.getBasicHeaderSegment().getParser();
                    ISID initiatorSessionID = parser.getInitiatorSessionID();
                    TargetSession session = new TargetSession(this, newConnection, initiatorSessionID, parser.getCommandSequenceNumber(), parser.getExpectedStatusSequenceNumber());
                    this.sessions.add(session);
                    this.workerPool.submit(new ConnectionHandler(newConnection));
                }
                catch (DigestException | InternetSCSIException | SettingsException e) {
                    LOGGER.info("Throws Exception", e);
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("Throws Exception", (Throwable)e);
        }
        System.out.println("Closing socket channel.");
        this.serverSocketChannel.close();
        for (TargetSession session : this.sessions) {
            System.out.println("Commiting uncommited changes.");
            session.getStorageModule().close();
        }
        return null;
    }

    public Configuration getConfig() {
        return this.config;
    }

    public DeviceIdentificationVpdPage getDeviceIdentificationVpdPage() {
        return this.deviceIdentificationVpdPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Target getTarget(String targetName) {
        HashMap<String, Target> hashMap = this.targets;
        synchronized (hashMap) {
            return this.targets.get(targetName);
        }
    }

    public synchronized void removeTargetSession(TargetSession session) {
        this.sessions.remove(session);
    }

    public String[] getTargetNames() {
        String[] returnNames = new String[this.targets.size()];
        returnNames = this.targets.keySet().toArray(returnNames);
        return returnNames;
    }

    public boolean isValidTargetName(String checkTargetName) {
        return this.targets.containsKey(checkTargetName);
    }

    public void stop() {
        this.running = false;
        for (TargetSession session : this.sessions) {
            if (session.getConnection().stop()) continue;
            this.running = true;
            LOGGER.error("Unable to stop session for " + session.getTargetName());
        }
    }

    private class ConnectionHandler
    implements Callable {
        private final Connection.TargetConnection targetConnection;

        ConnectionHandler(Connection.TargetConnection targetConnection) {
            this.targetConnection = targetConnection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Void call() throws Exception {
            try {
                this.targetConnection.call();
            }
            catch (Exception e) {
                LOGGER.error("running target error:", (Throwable)e);
            }
            finally {
                HashMap<String, Target> hashMap = TargetServer.this.targets;
                synchronized (hashMap) {
                    Target target = this.targetConnection.getTargetSession().getTarget();
                    if (target != null) {
                        TargetServer.this.targets.remove(target.getTargetName());
                        try {
                            target.getStorageModule().close();
                        }
                        catch (Exception e) {
                            LOGGER.error("Error when closing storage:", (Throwable)e);
                        }
                        LOGGER.info("closed local storage module");
                    } else {
                        LOGGER.warn("No target to delete on logout?");
                    }
                }
            }
            return null;
        }
    }
}

