/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.target.connection;

import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.security.DigestException;
import java.util.concurrent.Callable;
import javax.naming.OperationNotSupportedException;
import org.jscsi.exception.InternetSCSIException;
import org.jscsi.parser.OperationCode;
import org.jscsi.parser.ProtocolDataUnit;
import org.jscsi.target.connection.SessionType;
import org.jscsi.target.connection.TargetSenderWorker;
import org.jscsi.target.connection.TargetSession;
import org.jscsi.target.connection.phase.TargetFullFeaturePhase;
import org.jscsi.target.connection.phase.TargetLoginPhase;
import org.jscsi.target.connection.phase.TargetPhase;
import org.jscsi.target.connection.stage.fullfeature.PingStage;
import org.jscsi.target.settings.ConnectionSettingsNegotiator;
import org.jscsi.target.settings.SessionSettingsNegotiator;
import org.jscsi.target.settings.Settings;
import org.jscsi.target.settings.SettingsException;
import org.jscsi.target.util.FastByteArrayProvider;
import org.jscsi.target.util.SerialArithmeticNumber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Connection
extends Callable<Void> {
    public Settings getSettings();

    public SerialArithmeticNumber getStatusSequenceNumber();

    public boolean isLeadingConnection();

    public ProtocolDataUnit receivePdu() throws DigestException, InternetSCSIException, IOException, SettingsException;

    public void sendPdu(ProtocolDataUnit var1) throws InterruptedException, IOException, InternetSCSIException;

    public ConnectionSettingsNegotiator getConnectionSettingsNegotiator();

    public void setSession(TargetSession var1);

    public TargetSession getTargetSession();

    public void setStatusSequenceNumber(int var1);

    public void initializeConnectionSettingsNegotiator(SessionSettingsNegotiator var1);

    public byte[] getDataInArray(int var1);

    public boolean stop();

    public static class TargetConnection
    implements Connection {
        private static final Logger LOGGER = LoggerFactory.getLogger(TargetConnection.class);
        private TargetSession targetSession;
        TargetSenderWorker senderWorker;
        private ConnectionSettingsNegotiator connectionSettingsNegotiator;
        private TargetPhase phase;
        private SerialArithmeticNumber statusSequenceNumber;
        private FastByteArrayProvider dataInArrayProvider = new FastByteArrayProvider(4);
        private final boolean isLeadingConnection;
        private ProtocolDataUnit lastReceivedPDU;

        public TargetConnection(SocketChannel socketChannel, boolean isLeadingConnection) {
            this.isLeadingConnection = isLeadingConnection;
            this.senderWorker = new TargetSenderWorker(this, socketChannel);
        }

        @Override
        public byte[] getDataInArray(int length) {
            return this.dataInArrayProvider.getArray(length);
        }

        TargetSession getSession() {
            return this.targetSession;
        }

        @Override
        public void setSession(TargetSession session) {
            this.targetSession = session;
            this.senderWorker.setSession(session);
        }

        @Override
        public ProtocolDataUnit receivePdu() throws DigestException, InternetSCSIException, IOException, SettingsException {
            this.lastReceivedPDU = this.senderWorker.receiveFromWire();
            if (this.lastReceivedPDU.getBasicHeaderSegment().getOpCode().equals((Object)OperationCode.NOP_OUT)) {
                try {
                    new PingStage(new TargetFullFeaturePhase(this)).execute(this.lastReceivedPDU);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.lastReceivedPDU = this.senderWorker.receiveFromWire();
            }
            return this.lastReceivedPDU;
        }

        @Override
        public void sendPdu(ProtocolDataUnit pdu) throws InterruptedException, IOException, InternetSCSIException {
            this.senderWorker.sendOverWire(pdu);
        }

        @Override
        public Void call() {
            try {
                this.phase = new TargetLoginPhase(this);
                if (this.phase.execute(this.lastReceivedPDU)) {
                    LOGGER.debug("Login Phase successful");
                    Settings settings = this.getSettings();
                    if (this.isLeadingConnection) {
                        this.targetSession.setSessionType(SessionType.getSessionType(settings.getSessionType()));
                    }
                    this.targetSession.setTargetName(settings.getTargetName());
                    this.phase = new TargetFullFeaturePhase(this);
                    this.phase.execute();
                }
                this.senderWorker.close();
            }
            catch (IOException | InterruptedException | DigestException | OperationNotSupportedException | InternetSCSIException | SettingsException e) {
                LOGGER.error("Exception throws", e);
            }
            this.targetSession.removeTargetConnection(this);
            LOGGER.debug("closed connection");
            return null;
        }

        @Override
        public TargetSession getTargetSession() {
            return this.targetSession;
        }

        @Override
        public boolean isLeadingConnection() {
            return this.isLeadingConnection;
        }

        @Override
        public void initializeConnectionSettingsNegotiator(SessionSettingsNegotiator sessionSettingsNegotiator) {
            this.connectionSettingsNegotiator = new ConnectionSettingsNegotiator(sessionSettingsNegotiator);
        }

        @Override
        public Settings getSettings() {
            return this.connectionSettingsNegotiator.getSettings();
        }

        @Override
        public ConnectionSettingsNegotiator getConnectionSettingsNegotiator() {
            return this.connectionSettingsNegotiator;
        }

        @Override
        public SerialArithmeticNumber getStatusSequenceNumber() {
            return this.statusSequenceNumber;
        }

        @Override
        public void setStatusSequenceNumber(int statusSequenceNumber) {
            this.statusSequenceNumber = new SerialArithmeticNumber(statusSequenceNumber);
        }

        @Override
        public boolean stop() {
            if (this.phase instanceof TargetFullFeaturePhase) {
                ((TargetFullFeaturePhase)this.phase).stop();
                return true;
            }
            return false;
        }
    }
}

