/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.target.connection;

import java.nio.ByteBuffer;
import org.jscsi.parser.BasicHeaderSegment;
import org.jscsi.parser.OperationCode;
import org.jscsi.parser.ProtocolDataUnit;
import org.jscsi.parser.ProtocolDataUnitFactory;
import org.jscsi.parser.data.DataInParser;
import org.jscsi.parser.login.ISID;
import org.jscsi.parser.login.LoginResponseParser;
import org.jscsi.parser.login.LoginStage;
import org.jscsi.parser.login.LoginStatus;
import org.jscsi.parser.logout.LogoutResponse;
import org.jscsi.parser.logout.LogoutResponseParser;
import org.jscsi.parser.nop.NOPInParser;
import org.jscsi.parser.r2t.Ready2TransferParser;
import org.jscsi.parser.scsi.SCSIResponseParser;
import org.jscsi.parser.scsi.SCSIStatus;
import org.jscsi.parser.text.TextResponseParser;
import org.jscsi.parser.tmf.TaskManagementFunctionResponseParser;
import org.jscsi.target.scsi.ScsiResponseDataSegment;

public class TargetPduFactory {
    private static final ProtocolDataUnitFactory factory = new ProtocolDataUnitFactory();

    private TargetPduFactory() {
    }

    public static final ProtocolDataUnit createDataInPdu(boolean finalFlag, boolean acknowledgeFlag, boolean residualOverflowFlag, boolean residualUnderflowFlag, boolean statusFlag, SCSIStatus status, long logicalUnitNumber, int initiatorTaskTag, int targetTransferTag, int dataSequenceNumber, int bufferOffset, int residualCount, ByteBuffer dataSegment) {
        ProtocolDataUnit pdu = factory.create(false, finalFlag, OperationCode.SCSI_DATA_IN, "None", "None");
        BasicHeaderSegment bhs = pdu.getBasicHeaderSegment();
        DataInParser parser = (DataInParser)bhs.getParser();
        parser.setAcknowledgeFlag(acknowledgeFlag);
        parser.setResidualOverflowFlag(residualOverflowFlag);
        parser.setResidualUnderflowFlag(residualUnderflowFlag);
        parser.setStatusFlag(statusFlag);
        parser.setStatus(status);
        parser.setLogicalUnitNumber(logicalUnitNumber);
        bhs.setInitiatorTaskTag(initiatorTaskTag);
        parser.setTargetTransferTag(targetTransferTag);
        parser.setDataSequenceNumber(dataSequenceNumber);
        parser.setBufferOffset(bufferOffset);
        parser.setResidualCount(residualCount);
        pdu.setDataSegment(dataSegment);
        return pdu;
    }

    public static final ProtocolDataUnit createLoginResponsePdu(boolean transitFlag, boolean continueFlag, LoginStage currentStage, LoginStage nextStage, ISID initiatorSessionID, short targetSessionIdentifyingHandle, int initiatorTaskTag, LoginStatus status, ByteBuffer dataSegment) {
        ProtocolDataUnit pdu = factory.create(false, transitFlag, OperationCode.LOGIN_RESPONSE, "None", "None");
        BasicHeaderSegment bhs = pdu.getBasicHeaderSegment();
        LoginResponseParser parser = (LoginResponseParser)bhs.getParser();
        parser.setContinueFlag(continueFlag);
        parser.setCurrentStageNumber(currentStage);
        parser.setNextStageNumber(nextStage);
        parser.setInitiatorSessionID(initiatorSessionID);
        parser.setTargetSessionIdentifyingHandle(targetSessionIdentifyingHandle);
        bhs.setInitiatorTaskTag(initiatorTaskTag);
        parser.setStatus(status);
        pdu.setDataSegment(dataSegment);
        return pdu;
    }

    public static final ProtocolDataUnit createLogoutResponsePdu(LogoutResponse response, int initiatorTaskTag, short time2Wait, short time2Retain) {
        ProtocolDataUnit pdu = factory.create(false, true, OperationCode.LOGOUT_RESPONSE, "None", "None");
        BasicHeaderSegment bhs = pdu.getBasicHeaderSegment();
        LogoutResponseParser parser = (LogoutResponseParser)bhs.getParser();
        parser.setResponse(response);
        bhs.setInitiatorTaskTag(initiatorTaskTag);
        parser.setTime2Wait(time2Wait);
        parser.setTime2Retain(time2Retain);
        return pdu;
    }

    public static final ProtocolDataUnit createTMResponsePdu(TaskManagementFunctionResponseParser.ResponseCode response, int initiatorTaskTag) {
        ProtocolDataUnit pdu = factory.create(false, true, OperationCode.SCSI_TM_RESPONSE, "None", "None");
        BasicHeaderSegment bhs = pdu.getBasicHeaderSegment();
        TaskManagementFunctionResponseParser parser = (TaskManagementFunctionResponseParser)bhs.getParser();
        parser.setResponse(response);
        bhs.setInitiatorTaskTag(initiatorTaskTag);
        return pdu;
    }

    public static final ProtocolDataUnit createReadyToTransferPdu(long logicalUnitNumber, int initiatorTaskTag, int targetTransferTag, int readyToTransferSequenceNumber, int bufferOffset, int desiredDataTransferLength) {
        ProtocolDataUnit pdu = factory.create(false, true, OperationCode.R2T, "None", "None");
        BasicHeaderSegment bhs = pdu.getBasicHeaderSegment();
        Ready2TransferParser parser = (Ready2TransferParser)bhs.getParser();
        parser.setLogicalUnitNumber(logicalUnitNumber);
        bhs.setInitiatorTaskTag(initiatorTaskTag);
        parser.setTargetTransferTag(targetTransferTag);
        parser.setReady2TransferSequenceNumber(readyToTransferSequenceNumber);
        parser.setBufferOffset(bufferOffset);
        parser.setDesiredDataTransferLength(desiredDataTransferLength);
        return pdu;
    }

    public static final ProtocolDataUnit createSCSIResponsePdu(boolean bidirectionalReadResidualOverflow, boolean bidirectionalReadResidualUnderflow, boolean residualOverflow, boolean residualUnderflow, SCSIResponseParser.ServiceResponse response, SCSIStatus status, int initiatorTaskTag, int snackTag, int expectedDataSequenceNumber, int bidirectionalReadResidualCount, int residualCount, ScsiResponseDataSegment scsiResponseDataSegment) {
        ProtocolDataUnit pdu = factory.create(false, true, OperationCode.SCSI_RESPONSE, "None", "None");
        BasicHeaderSegment bhs = pdu.getBasicHeaderSegment();
        SCSIResponseParser parser = (SCSIResponseParser)bhs.getParser();
        parser.setBidirectionalReadResidualOverflow(bidirectionalReadResidualOverflow);
        parser.setBidirectionalReadResidualUnderflow(bidirectionalReadResidualUnderflow);
        parser.setResidualOverflow(residualOverflow);
        parser.setResidualUnderflow(residualUnderflow);
        parser.setResponse(response);
        parser.setStatus(status);
        bhs.setInitiatorTaskTag(initiatorTaskTag);
        parser.setSNACKTag(snackTag);
        parser.setExpectedDataSequenceNumber(expectedDataSequenceNumber);
        parser.setBidirectionalReadResidualCount(bidirectionalReadResidualCount);
        parser.setResidualCount(residualCount);
        pdu.setDataSegment(scsiResponseDataSegment.serialize());
        return pdu;
    }

    public static final ProtocolDataUnit createTextResponsePdu(boolean finalFlag, boolean continueFlag, long logicalUnitNumber, int initiatorTaskTag, int targetTransferTag, ByteBuffer dataSegment) {
        ProtocolDataUnit pdu = factory.create(false, finalFlag, OperationCode.TEXT_RESPONSE, "None", "None");
        BasicHeaderSegment bhs = pdu.getBasicHeaderSegment();
        TextResponseParser parser = (TextResponseParser)bhs.getParser();
        parser.setContinueFlag(continueFlag);
        parser.setLogicalUnitNumber(logicalUnitNumber);
        bhs.setInitiatorTaskTag(initiatorTaskTag);
        parser.setTargetTransferTag(targetTransferTag);
        pdu.setDataSegment(dataSegment);
        return pdu;
    }

    public static final ProtocolDataUnit createNopInPDU(long logicalUnitNumber, int initiatorTaskTag, int targetTransferTag, ByteBuffer dataSegment, int statusSequenceNumber) {
        ProtocolDataUnit pdu = factory.create(false, true, OperationCode.NOP_IN, "None", "None");
        BasicHeaderSegment bhs = pdu.getBasicHeaderSegment();
        NOPInParser parser = (NOPInParser)bhs.getParser();
        parser.setLogicalUnitNumber(logicalUnitNumber);
        bhs.setInitiatorTaskTag(initiatorTaskTag);
        parser.setTargetTransferTag(targetTransferTag);
        parser.setStatusSequenceNumber(statusSequenceNumber);
        pdu.setDataSegment(dataSegment);
        return pdu;
    }
}

