/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.target.connection;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import java.security.DigestException;
import org.jscsi.exception.InternetSCSIException;
import org.jscsi.parser.BasicHeaderSegment;
import org.jscsi.parser.InitiatorMessageParser;
import org.jscsi.parser.OperationCode;
import org.jscsi.parser.ProtocolDataUnit;
import org.jscsi.parser.ProtocolDataUnitFactory;
import org.jscsi.parser.TargetMessageParser;
import org.jscsi.parser.scsi.SCSICommandParser;
import org.jscsi.target.connection.Connection;
import org.jscsi.target.connection.TargetSession;
import org.jscsi.target.scsi.cdb.ScsiOperationCode;
import org.jscsi.target.settings.Settings;
import org.jscsi.target.settings.SettingsException;
import org.jscsi.target.util.Debug;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TargetSenderWorker {
    private static final Logger LOGGER = LoggerFactory.getLogger(TargetSenderWorker.class);
    private final Connection connection;
    private TargetSession session;
    private final SocketChannel socketChannel;
    private final ProtocolDataUnitFactory protocolDataUnitFactory;
    private boolean initialPdu;

    public TargetSenderWorker(Connection connection, SocketChannel socketChannel) {
        this.connection = connection;
        this.socketChannel = socketChannel;
        this.protocolDataUnitFactory = new ProtocolDataUnitFactory();
        this.initialPdu = connection.isLeadingConnection();
    }

    void setSession(TargetSession session) {
        this.session = session;
    }

    public final void close() throws IOException {
        this.socketChannel.close();
    }

    ProtocolDataUnit receiveFromWire() throws DigestException, InternetSCSIException, IOException, SettingsException {
        ProtocolDataUnit pdu;
        if (this.initialPdu) {
            pdu = this.protocolDataUnitFactory.create("None", "None");
        } else {
            Settings settings = this.connection.getSettings();
            pdu = this.protocolDataUnitFactory.create(settings.getHeaderDigest(), settings.getDataDigest());
        }
        try {
            pdu.read(this.socketChannel);
        }
        catch (ClosedChannelException e) {
            throw new InternetSCSIException((Exception)e);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Receiving this PDU:\n" + pdu);
        }
        BasicHeaderSegment bhs = pdu.getBasicHeaderSegment();
        InitiatorMessageParser parser = (InitiatorMessageParser)bhs.getParser();
        if (LOGGER.isDebugEnabled()) {
            if (bhs.getOpCode() == OperationCode.SCSI_COMMAND) {
                SCSICommandParser scsiParser = (SCSICommandParser)bhs.getParser();
                ScsiOperationCode scsiOpCode = ScsiOperationCode.valueOf(scsiParser.getCDB().get(0));
                LOGGER.debug("scsiOpCode = " + (Object)((Object)scsiOpCode));
                LOGGER.debug("CDB bytes: \n" + Debug.byteBufferToString(scsiParser.getCDB()));
            }
            if (this.connection == null) {
                LOGGER.debug("connection: null");
            } else if (this.connection.getStatusSequenceNumber() == null) {
                LOGGER.debug("connection.getStatusSequenceNumber: null");
            } else {
                LOGGER.debug("connection.getStatusSequenceNumber: " + this.connection.getStatusSequenceNumber().getValue());
            }
        }
        if (this.initialPdu) {
            this.initialPdu = false;
        }
        try {
            if (parser.incrementSequenceNumber()) {
                this.session.getExpectedCommandSequenceNumber().increment();
            }
        }
        catch (NullPointerException exc) {
            // empty catch block
        }
        return pdu;
    }

    final void sendOverWire(ProtocolDataUnit pdu) throws InternetSCSIException, IOException, InterruptedException {
        TargetMessageParser parser = (TargetMessageParser)pdu.getBasicHeaderSegment().getParser();
        parser.setExpectedCommandSequenceNumber(this.session.getExpectedCommandSequenceNumber().getValue());
        parser.setMaximumCommandSequenceNumber(this.session.getMaximumCommandSequenceNumber().getValue());
        boolean incrementSequenceNumber = parser.incrementSequenceNumber();
        if (incrementSequenceNumber) {
            parser.setStatusSequenceNumber(this.connection.getStatusSequenceNumber().getValue());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Sending this PDU:\n" + pdu);
        }
        pdu.write(this.socketChannel);
        if (incrementSequenceNumber) {
            this.connection.getStatusSequenceNumber().increment();
        }
    }
}

