/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.target.connection;

import org.jscsi.parser.login.ISID;
import org.jscsi.target.Target;
import org.jscsi.target.TargetServer;
import org.jscsi.target.connection.Connection;
import org.jscsi.target.connection.SessionType;
import org.jscsi.target.settings.SessionSettingsNegotiator;
import org.jscsi.target.storage.IStorageModule;
import org.jscsi.target.util.SerialArithmeticNumber;

public class TargetSession {
    private TargetServer targetServer;
    private Target target;
    private Connection connection;
    private ISID initiatorSessionID;
    private SerialArithmeticNumber expectedCommandSequenceNumber;
    private final int commandWindowSize = 1;
    private SessionSettingsNegotiator sessionSettingsNegotiator;
    private short targetSessionIdentifyingHandle;
    private static short nextTargetSessionIdentifyingHandle = 1;
    private SessionType sessionType;

    private static short getNextTargetSessionIdentifyingHandle() {
        short s = nextTargetSessionIdentifyingHandle;
        nextTargetSessionIdentifyingHandle = (short)(s + 1);
        short handle = s;
        if (handle == 0) {
            short s2 = nextTargetSessionIdentifyingHandle;
            nextTargetSessionIdentifyingHandle = (short)(s2 + 1);
            handle = s2;
        }
        return handle;
    }

    public TargetSession(TargetServer target, Connection connection, ISID initiatorSessionID, int expectedCommandSequenceNumber, int statusSequenceNumber) {
        this.targetServer = target;
        connection.setSession(this);
        this.connection = connection;
        connection.setStatusSequenceNumber(statusSequenceNumber);
        this.sessionSettingsNegotiator = new SessionSettingsNegotiator();
        connection.initializeConnectionSettingsNegotiator(this.sessionSettingsNegotiator);
        this.initiatorSessionID = initiatorSessionID;
        this.targetSessionIdentifyingHandle = TargetSession.getNextTargetSessionIdentifyingHandle();
        this.expectedCommandSequenceNumber = new SerialArithmeticNumber(expectedCommandSequenceNumber);
    }

    public TargetServer getTargetServer() {
        return this.targetServer;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public Target getTarget() {
        return this.target;
    }

    public IStorageModule getStorageModule() {
        return this.target.getStorageModule();
    }

    SerialArithmeticNumber getExpectedCommandSequenceNumber() {
        return this.expectedCommandSequenceNumber;
    }

    public ISID getInitiatorSessionID() {
        return this.initiatorSessionID;
    }

    SerialArithmeticNumber getMaximumCommandSequenceNumber() {
        return new SerialArithmeticNumber(this.expectedCommandSequenceNumber.getValue() + 1 - 1);
    }

    public short getTargetSessionIdentifyingHandle() {
        return this.targetSessionIdentifyingHandle;
    }

    public boolean isNormalSession() {
        return this.sessionType == SessionType.NORMAL;
    }

    void removeTargetConnection(Connection connection) {
        this.targetServer.removeTargetSession(this);
    }

    boolean setSessionType(SessionType sessionType) {
        if (sessionType == null || this.sessionType != null) {
            return false;
        }
        this.sessionType = sessionType;
        return true;
    }

    public void setTargetName(String targetName) {
        if (targetName == null) {
            this.target = null;
        }
        this.target = this.targetServer.getTarget(targetName);
    }

    public String getTargetName() {
        if (this.target != null) {
            return this.target.getTargetName();
        }
        return null;
    }
}

