/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.target.connection.phase;

import java.io.IOException;
import java.security.DigestException;
import org.jscsi.exception.InternetSCSIException;
import org.jscsi.parser.BasicHeaderSegment;
import org.jscsi.parser.ProtocolDataUnit;
import org.jscsi.parser.scsi.SCSICommandParser;
import org.jscsi.target.connection.Connection;
import org.jscsi.target.connection.phase.TargetPhase;
import org.jscsi.target.connection.stage.TMStage;
import org.jscsi.target.connection.stage.fullfeature.FormatUnitStage;
import org.jscsi.target.connection.stage.fullfeature.InquiryStage;
import org.jscsi.target.connection.stage.fullfeature.LogoutStage;
import org.jscsi.target.connection.stage.fullfeature.ModeSenseStage;
import org.jscsi.target.connection.stage.fullfeature.PingStage;
import org.jscsi.target.connection.stage.fullfeature.ReadCapacityStage;
import org.jscsi.target.connection.stage.fullfeature.ReadStage;
import org.jscsi.target.connection.stage.fullfeature.ReportLunsStage;
import org.jscsi.target.connection.stage.fullfeature.RequestSenseStage;
import org.jscsi.target.connection.stage.fullfeature.SendDiagnosticStage;
import org.jscsi.target.connection.stage.fullfeature.TargetFullFeatureStage;
import org.jscsi.target.connection.stage.fullfeature.TestUnitReadyStage;
import org.jscsi.target.connection.stage.fullfeature.TextNegotiationStage;
import org.jscsi.target.connection.stage.fullfeature.UnsupportedOpCodeStage;
import org.jscsi.target.connection.stage.fullfeature.WriteStage;
import org.jscsi.target.scsi.cdb.ScsiOperationCode;
import org.jscsi.target.settings.SettingsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TargetFullFeaturePhase
extends TargetPhase {
    private static final Logger LOGGER = LoggerFactory.getLogger(TargetFullFeaturePhase.class);
    private TargetFullFeatureStage stage;
    private boolean running;

    public TargetFullFeaturePhase(Connection connection) {
        super(connection);
    }

    @Override
    public boolean execute() throws DigestException, IOException, InterruptedException, InternetSCSIException, SettingsException {
        this.running = true;
        while (this.running) {
            ProtocolDataUnit pdu = this.connection.receivePdu();
            BasicHeaderSegment bhs = pdu.getBasicHeaderSegment();
            switch (bhs.getOpCode()) {
                case SCSI_COMMAND: {
                    if (this.connection.getTargetSession().isNormalSession()) {
                        SCSICommandParser parser = (SCSICommandParser)bhs.getParser();
                        ScsiOperationCode scsiOpCode = ScsiOperationCode.valueOf(parser.getCDB().get(0));
                        LOGGER.debug("scsiOpCode = " + (Object)((Object)scsiOpCode));
                        if (scsiOpCode != null) {
                            switch (scsiOpCode) {
                                case TEST_UNIT_READY: {
                                    this.stage = new TestUnitReadyStage(this);
                                    break;
                                }
                                case REQUEST_SENSE: {
                                    this.stage = new RequestSenseStage(this);
                                    break;
                                }
                                case FORMAT_UNIT: {
                                    this.stage = new FormatUnitStage(this);
                                    break;
                                }
                                case INQUIRY: {
                                    this.stage = new InquiryStage(this);
                                    break;
                                }
                                case MODE_SELECT_6: {
                                    this.stage = null;
                                    scsiOpCode = null;
                                    break;
                                }
                                case MODE_SENSE_6: {
                                    this.stage = new ModeSenseStage(this);
                                    if (((ModeSenseStage)this.stage).canHandle(pdu)) break;
                                    this.stage = null;
                                    scsiOpCode = null;
                                    break;
                                }
                                case SEND_DIAGNOSTIC: {
                                    this.stage = new SendDiagnosticStage(this);
                                    break;
                                }
                                case READ_CAPACITY_10: 
                                case READ_CAPACITY_16: {
                                    this.stage = new ReadCapacityStage(this);
                                    break;
                                }
                                case WRITE_6: 
                                case WRITE_10: {
                                    this.stage = new WriteStage(this);
                                    break;
                                }
                                case READ_6: 
                                case READ_10: {
                                    this.stage = new ReadStage(this);
                                    break;
                                }
                                case REPORT_LUNS: {
                                    this.stage = new ReportLunsStage(this);
                                    break;
                                }
                                default: {
                                    scsiOpCode = null;
                                }
                            }
                        }
                        if (scsiOpCode != null) break;
                        LOGGER.error("Unsupported SCSI OpCode 0x" + Integer.toHexString(parser.getCDB().get(0) & 0xFF) + " in SCSI Command PDU.");
                        this.stage = new UnsupportedOpCodeStage(this);
                        break;
                    }
                    throw new InternetSCSIException("received SCSI command in discovery session");
                }
                case SCSI_TM_REQUEST: {
                    this.stage = new TMStage(this);
                    break;
                }
                case NOP_OUT: {
                    this.stage = new PingStage(this);
                    break;
                }
                case TEXT_REQUEST: {
                    this.stage = new TextNegotiationStage(this);
                    break;
                }
                case LOGOUT_REQUEST: {
                    this.stage = new LogoutStage(this);
                    this.running = false;
                    break;
                }
                default: {
                    LOGGER.error("Received unsupported opcode for " + pdu.getBasicHeaderSegment().getOpCode());
                    this.stage = new UnsupportedOpCodeStage(this);
                }
            }
            this.stage.execute(pdu);
        }
        return false;
    }

    public void stop() {
        this.running = false;
    }
}

