/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.target.connection.phase;

import java.io.IOException;
import java.security.DigestException;
import org.jscsi.exception.InternetSCSIException;
import org.jscsi.parser.BasicHeaderSegment;
import org.jscsi.parser.ProtocolDataUnit;
import org.jscsi.parser.login.LoginRequestParser;
import org.jscsi.parser.login.LoginStage;
import org.jscsi.target.connection.Connection;
import org.jscsi.target.connection.phase.TargetPhase;
import org.jscsi.target.connection.stage.login.LoginOperationalParameterNegotiationStage;
import org.jscsi.target.connection.stage.login.SecurityNegotiationStage;
import org.jscsi.target.connection.stage.login.TargetLoginStage;
import org.jscsi.target.settings.ConnectionSettingsNegotiator;
import org.jscsi.target.settings.SettingsException;

public final class TargetLoginPhase
extends TargetPhase {
    private TargetLoginStage stage;
    private boolean authenticated = true;
    private boolean firstPdu = true;

    public TargetLoginPhase(Connection connection) {
        super(connection);
    }

    @Override
    public boolean execute(ProtocolDataUnit pdu) throws IOException, InterruptedException, InternetSCSIException, DigestException, SettingsException {
        ConnectionSettingsNegotiator negotiator = this.connection.getConnectionSettingsNegotiator();
        while (!negotiator.beginNegotiation()) {
        }
        boolean loginSuccessful = true;
        try {
            LoginStage nextStageNumber;
            BasicHeaderSegment bhs = pdu.getBasicHeaderSegment();
            LoginRequestParser parser = (LoginRequestParser)bhs.getParser();
            if (parser.getCurrentStageNumber() == LoginStage.SECURITY_NEGOTIATION) {
                this.stage = new SecurityNegotiationStage(this);
                this.stage.execute(pdu);
                nextStageNumber = this.stage.getNextStageNumber();
                if (nextStageNumber == null) {
                    loginSuccessful = false;
                    boolean bl = false;
                    return bl;
                }
                this.authenticated = true;
                if (nextStageNumber == LoginStage.LOGIN_OPERATIONAL_NEGOTIATION) {
                    pdu = this.connection.receivePdu();
                    bhs = pdu.getBasicHeaderSegment();
                    parser = (LoginRequestParser)bhs.getParser();
                } else {
                    if (nextStageNumber == LoginStage.FULL_FEATURE_PHASE) {
                        boolean bl = true;
                        return bl;
                    }
                    loginSuccessful = false;
                    boolean bl = false;
                    return bl;
                }
            }
            if (parser != null && this.authenticated && parser.getCurrentStageNumber() == LoginStage.LOGIN_OPERATIONAL_NEGOTIATION) {
                this.stage = new LoginOperationalParameterNegotiationStage(this);
                this.stage.execute(pdu);
                nextStageNumber = this.stage.getNextStageNumber();
                if (nextStageNumber == LoginStage.FULL_FEATURE_PHASE) {
                    boolean bl = true;
                    return bl;
                }
            }
            loginSuccessful = false;
            boolean bl = false;
            return bl;
        }
        catch (DigestException e) {
            loginSuccessful = false;
            throw e;
        }
        catch (IOException e) {
            loginSuccessful = false;
            throw e;
        }
        catch (InterruptedException e) {
            loginSuccessful = false;
            throw e;
        }
        catch (InternetSCSIException e) {
            loginSuccessful = false;
            throw e;
        }
        catch (SettingsException e) {
            loginSuccessful = false;
            throw e;
        }
        finally {
            negotiator.finishNegotiation(loginSuccessful);
        }
    }

    public boolean getFirstPduAndSetToFalse() {
        if (!this.firstPdu) {
            return false;
        }
        this.firstPdu = false;
        return true;
    }

    public final boolean getAuthenticated() {
        return this.authenticated;
    }
}

