/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.target.connection.stage.fullfeature;

import java.io.IOException;
import java.security.DigestException;
import org.jscsi.exception.InternetSCSIException;
import org.jscsi.parser.BasicHeaderSegment;
import org.jscsi.parser.ProtocolDataUnit;
import org.jscsi.parser.scsi.SCSICommandParser;
import org.jscsi.parser.scsi.SCSIResponseParser;
import org.jscsi.parser.scsi.SCSIStatus;
import org.jscsi.target.connection.TargetPduFactory;
import org.jscsi.target.connection.phase.TargetFullFeaturePhase;
import org.jscsi.target.connection.stage.fullfeature.ReadStage;
import org.jscsi.target.connection.stage.fullfeature.TargetFullFeatureStage;
import org.jscsi.target.scsi.ScsiResponseDataSegment;
import org.jscsi.target.scsi.cdb.FormatUnitCDB;
import org.jscsi.target.scsi.sense.AdditionalSenseBytes;
import org.jscsi.target.scsi.sense.AdditionalSenseCodeAndQualifier;
import org.jscsi.target.scsi.sense.ErrorType;
import org.jscsi.target.scsi.sense.FixedFormatSenseData;
import org.jscsi.target.scsi.sense.SenseKey;
import org.jscsi.target.scsi.sense.information.FourByteInformation;
import org.jscsi.target.scsi.sense.senseDataDescriptor.senseKeySpecific.FieldPointerSenseKeySpecificData;
import org.jscsi.target.settings.SettingsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormatUnitStage
extends TargetFullFeatureStage {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReadStage.class);

    public FormatUnitStage(TargetFullFeaturePhase targetFullFeaturePhase) {
        super(targetFullFeaturePhase);
    }

    @Override
    public void execute(ProtocolDataUnit pdu) throws IOException, InterruptedException, InternetSCSIException, DigestException, SettingsException {
        ProtocolDataUnit responsePdu;
        LOGGER.debug("Initiator has sent FORMAT UNIT command.");
        BasicHeaderSegment bhs = pdu.getBasicHeaderSegment();
        SCSICommandParser parser = (SCSICommandParser)bhs.getParser();
        FormatUnitCDB cdb = new FormatUnitCDB(parser.getCDB());
        FieldPointerSenseKeySpecificData[] illegalFieldPointers = cdb.getIllegalFieldPointers();
        if (illegalFieldPointers != null) {
            FixedFormatSenseData senseData = new FixedFormatSenseData(false, ErrorType.CURRENT, false, false, false, SenseKey.ILLEGAL_REQUEST, new FourByteInformation(), new FourByteInformation(), AdditionalSenseCodeAndQualifier.INVALID_FIELD_IN_CDB, 0, illegalFieldPointers[0], new AdditionalSenseBytes());
            responsePdu = TargetPduFactory.createSCSIResponsePdu(false, false, false, false, SCSIResponseParser.ServiceResponse.COMMAND_COMPLETED_AT_TARGET, SCSIStatus.CHECK_CONDITION, bhs.getInitiatorTaskTag(), 0, 0, 0, 0, new ScsiResponseDataSegment(senseData, parser.getExpectedDataTransferLength()));
        } else {
            responsePdu = FormatUnitStage.createScsiResponsePdu(SCSIStatus.GOOD, bhs.getInitiatorTaskTag(), parser.getExpectedDataTransferLength(), 0);
        }
        this.connection.sendPdu(responsePdu);
    }
}

