/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.target.connection.stage.fullfeature;

import java.io.IOException;
import java.security.DigestException;
import org.jscsi.exception.InternetSCSIException;
import org.jscsi.parser.BasicHeaderSegment;
import org.jscsi.parser.ProtocolDataUnit;
import org.jscsi.parser.scsi.SCSICommandParser;
import org.jscsi.target.connection.phase.TargetFullFeaturePhase;
import org.jscsi.target.connection.stage.fullfeature.TargetFullFeatureStage;
import org.jscsi.target.scsi.IResponseData;
import org.jscsi.target.scsi.cdb.InquiryCDB;
import org.jscsi.target.scsi.inquiry.PageCode;
import org.jscsi.target.scsi.inquiry.StandardInquiryData;
import org.jscsi.target.scsi.inquiry.SupportedVpdPages;
import org.jscsi.target.scsi.sense.senseDataDescriptor.senseKeySpecific.FieldPointerSenseKeySpecificData;
import org.jscsi.target.settings.SettingsException;
import org.jscsi.target.util.Debug;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InquiryStage
extends TargetFullFeatureStage {
    private static final Logger LOGGER = LoggerFactory.getLogger(InquiryStage.class);

    public InquiryStage(TargetFullFeaturePhase targetFullFeaturePhase) {
        super(targetFullFeaturePhase);
    }

    @Override
    public void execute(ProtocolDataUnit pdu) throws IOException, InterruptedException, InternetSCSIException, DigestException, SettingsException {
        BasicHeaderSegment bhs = pdu.getBasicHeaderSegment();
        SCSICommandParser parser = (SCSICommandParser)bhs.getParser();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("CDB bytes: \n" + Debug.byteBufferToString(parser.getCDB()));
        }
        InquiryCDB cdb = new InquiryCDB(parser.getCDB());
        FieldPointerSenseKeySpecificData[] illegalFieldPointers = cdb.getIllegalFieldPointers();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("cdb.getAllocationLength() = " + cdb.getAllocationLength());
            LOGGER.debug("cdb.getEnableVitalProductData() = " + cdb.getEnableVitalProductData());
            LOGGER.debug("cdb.isNormalACA() = " + cdb.isNormalACA());
            LOGGER.debug("cdb.getPageCode() = " + cdb.getPageCode());
            LOGGER.debug("cdb.getPageCode().getVitalProductDataPageName() = " + (Object)((Object)cdb.getPageCode().getVitalProductDataPageName()));
        }
        if (illegalFieldPointers != null) {
            LOGGER.error("illegal INQUIRY request");
            ProtocolDataUnit responsePdu = InquiryStage.createFixedFormatErrorPdu(illegalFieldPointers, bhs.getInitiatorTaskTag(), parser.getExpectedDataTransferLength());
            this.connection.sendPdu(responsePdu);
        } else {
            IResponseData responseData;
            if (!cdb.getEnableVitalProductData()) {
                responseData = StandardInquiryData.getInstance();
            } else {
                PageCode.VitalProductDataPageName pageName = cdb.getPageCode().getVitalProductDataPageName();
                switch (pageName) {
                    case SUPPORTED_VPD_PAGES: {
                        responseData = SupportedVpdPages.getInstance();
                        break;
                    }
                    case DEVICE_IDENTIFICATION: {
                        responseData = this.session.getTargetServer().getDeviceIdentificationVpdPage();
                        break;
                    }
                    default: {
                        throw new InternetSCSIException();
                    }
                }
            }
            this.sendResponse(bhs.getInitiatorTaskTag(), parser.getExpectedDataTransferLength(), responseData);
        }
    }
}

