/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.target.connection.stage.fullfeature;

import java.io.IOException;
import java.security.DigestException;
import org.jscsi.exception.InternetSCSIException;
import org.jscsi.parser.BasicHeaderSegment;
import org.jscsi.parser.ProtocolDataUnit;
import org.jscsi.parser.scsi.SCSICommandParser;
import org.jscsi.target.connection.phase.TargetFullFeaturePhase;
import org.jscsi.target.connection.stage.fullfeature.TargetFullFeatureStage;
import org.jscsi.target.scsi.cdb.ModeSense6Cdb;
import org.jscsi.target.scsi.modeSense.CachingModePage;
import org.jscsi.target.scsi.modeSense.HeaderType;
import org.jscsi.target.scsi.modeSense.InformationExceptionsControlModePage;
import org.jscsi.target.scsi.modeSense.ModePage;
import org.jscsi.target.scsi.modeSense.ModePageCode;
import org.jscsi.target.scsi.modeSense.ModeParameterList;
import org.jscsi.target.scsi.modeSense.ModeParameterListBuilder;
import org.jscsi.target.scsi.modeSense.ShortLogicalBlockDescriptor;
import org.jscsi.target.settings.SettingsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ModeSenseStage
extends TargetFullFeatureStage {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModeSenseStage.class);

    public ModeSenseStage(TargetFullFeaturePhase targetFullFeaturePhase) {
        super(targetFullFeaturePhase);
    }

    @Override
    public void execute(ProtocolDataUnit pdu) throws IOException, InterruptedException, InternetSCSIException, DigestException, SettingsException {
        BasicHeaderSegment bhs = pdu.getBasicHeaderSegment();
        SCSICommandParser parser = (SCSICommandParser)bhs.getParser();
        ModeSense6Cdb cdb = new ModeSense6Cdb(parser.getCDB());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(Boolean.toString(cdb.getDisableBlockDescriptors()));
            LOGGER.debug(cdb.getPageControl().toString());
            LOGGER.debug(Integer.toString(cdb.getPageCode()));
            LOGGER.debug(Integer.toString(cdb.getSubpageCode()));
            LOGGER.debug("cdb.getAllocationLength() = " + cdb.getAllocationLength());
        }
        ModePageCode modePageCode = cdb.getModePage();
        ModePage[] modePages = null;
        if (modePageCode == ModePageCode.INFORMATIONAL_EXCEPTIONS_CONTROL_MODE_PAGE) {
            modePages = new ModePage[]{ModeSenseStage.getInformationExceptionsControlModePage()};
        } else if (modePageCode == ModePageCode.CACHING_MODE_PAGE) {
            modePages = new ModePage[]{ModeSenseStage.getCachingModePage()};
        } else if (modePageCode == ModePageCode.RETURN_ALL_MODE_PAGES_ONLY) {
            modePages = new ModePage[]{ModeSenseStage.getInformationExceptionsControlModePage(), ModeSenseStage.getCachingModePage()};
        }
        if (modePages == null) {
            throw new InternetSCSIException();
        }
        ModeParameterListBuilder builder = new ModeParameterListBuilder(HeaderType.MODE_PARAMETER_HEADER_6);
        builder.setLogicalBlockDescriptors(new ShortLogicalBlockDescriptor(this.session.getStorageModule().getSizeInBlocks(), this.session.getStorageModule().getBlockSize()));
        builder.setModePages(modePages);
        ModeParameterList modeParameterList = ModeParameterList.build(builder);
        this.sendResponse(bhs.getInitiatorTaskTag(), parser.getExpectedDataTransferLength(), modeParameterList);
    }

    private static final InformationExceptionsControlModePage getInformationExceptionsControlModePage() {
        return new InformationExceptionsControlModePage(false, false, false, false, true, false, false, 0, 0, 0);
    }

    private static final CachingModePage getCachingModePage() {
        return new CachingModePage(false, false, true, false, false, true, false, false, true, 0, 0, 0, 0, 65535, 65535, true, false, false, false, 20, 0);
    }

    public boolean canHandle(ProtocolDataUnit pdu) {
        BasicHeaderSegment bhs = pdu.getBasicHeaderSegment();
        SCSICommandParser parser = (SCSICommandParser)bhs.getParser();
        ModeSense6Cdb cdb = new ModeSense6Cdb(parser.getCDB());
        ModePageCode modePageCode = cdb.getModePage();
        if (modePageCode == ModePageCode.INFORMATIONAL_EXCEPTIONS_CONTROL_MODE_PAGE) {
            return true;
        }
        if (modePageCode == ModePageCode.CACHING_MODE_PAGE) {
            return true;
        }
        return modePageCode == ModePageCode.RETURN_ALL_MODE_PAGES_ONLY;
    }
}

