/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.target.connection.stage.fullfeature;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.DigestException;
import org.jscsi.exception.InternetSCSIException;
import org.jscsi.parser.BasicHeaderSegment;
import org.jscsi.parser.ProtocolDataUnit;
import org.jscsi.parser.nop.NOPOutParser;
import org.jscsi.target.connection.TargetPduFactory;
import org.jscsi.target.connection.phase.TargetFullFeaturePhase;
import org.jscsi.target.connection.stage.fullfeature.TargetFullFeatureStage;
import org.jscsi.target.settings.SettingsException;

public class PingStage
extends TargetFullFeatureStage {
    private static final int RESERVED_TAG_VALUE = -1;

    public PingStage(TargetFullFeaturePhase targetFullFeaturePhase) {
        super(targetFullFeaturePhase);
    }

    @Override
    public void execute(ProtocolDataUnit pdu) throws IOException, InterruptedException, InternetSCSIException, DigestException, SettingsException {
        BasicHeaderSegment bhs = pdu.getBasicHeaderSegment();
        NOPOutParser parser = (NOPOutParser)bhs.getParser();
        if (parser.getTargetTransferTag() != -1) {
            throw new InternetSCSIException("NOP-Out PDU TargetTransferTag = " + parser.getTargetTransferTag() + " in PingStage");
        }
        if (bhs.getInitiatorTaskTag() == -1) {
            return;
        }
        int dataSegmentLength = Math.min(pdu.getDataSegment().capacity(), this.settings.getMaxRecvDataSegmentLength());
        ByteBuffer responseDataSegment = ByteBuffer.allocate(dataSegmentLength);
        responseDataSegment.put(pdu.getDataSegment().array(), 0, dataSegmentLength);
        ProtocolDataUnit responsePdu = TargetPduFactory.createNopInPDU(0L, bhs.getInitiatorTaskTag(), -1, responseDataSegment, parser.getExpectedStatusSequenceNumber());
        this.connection.sendPdu(responsePdu);
    }
}

