/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.target.connection.stage.fullfeature;

import java.io.IOException;
import java.security.DigestException;
import org.jscsi.exception.InternetSCSIException;
import org.jscsi.parser.BasicHeaderSegment;
import org.jscsi.parser.ProtocolDataUnit;
import org.jscsi.parser.scsi.SCSICommandParser;
import org.jscsi.target.connection.phase.TargetFullFeaturePhase;
import org.jscsi.target.connection.stage.fullfeature.TargetFullFeatureStage;
import org.jscsi.target.scsi.cdb.ReadCapacity10Cdb;
import org.jscsi.target.scsi.cdb.ReadCapacity16Cdb;
import org.jscsi.target.scsi.cdb.ReadCapacityCdb;
import org.jscsi.target.scsi.cdb.ScsiOperationCode;
import org.jscsi.target.scsi.readCapacity.ReadCapacity10ParameterData;
import org.jscsi.target.scsi.readCapacity.ReadCapacity16ParameterData;
import org.jscsi.target.scsi.readCapacity.ReadCapacityParameterData;
import org.jscsi.target.scsi.sense.AdditionalSenseCodeAndQualifier;
import org.jscsi.target.scsi.sense.senseDataDescriptor.senseKeySpecific.FieldPointerSenseKeySpecificData;
import org.jscsi.target.settings.SettingsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReadCapacityStage
extends TargetFullFeatureStage {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReadCapacityStage.class);

    public ReadCapacityStage(TargetFullFeaturePhase targetFullFeaturePhase) {
        super(targetFullFeaturePhase);
    }

    @Override
    public void execute(ProtocolDataUnit pdu) throws IOException, InterruptedException, InternetSCSIException, DigestException, SettingsException {
        ReadCapacityCdb cdb;
        BasicHeaderSegment bhs = pdu.getBasicHeaderSegment();
        SCSICommandParser parser = (SCSICommandParser)bhs.getParser();
        ScsiOperationCode opCode = ScsiOperationCode.valueOf(parser.getCDB().get(0));
        if (opCode == ScsiOperationCode.READ_CAPACITY_10) {
            cdb = new ReadCapacity10Cdb(parser.getCDB());
        } else if (opCode == ScsiOperationCode.READ_CAPACITY_16) {
            cdb = new ReadCapacity16Cdb(parser.getCDB());
        } else {
            throw new InternetSCSIException("wrong SCSI Operation Code " + (Object)((Object)opCode) + " in ReadCapacityStage");
        }
        if (this.session.getStorageModule().checkBounds(cdb.getLogicalBlockAddress(), 0) != 0) {
            LOGGER.error("encountered " + cdb.getClass() + " in ReadCapacityStage with " + "LOGICAL BLOCK ADDRESS = " + cdb.getLogicalBlockAddress());
            FieldPointerSenseKeySpecificData fp = new FieldPointerSenseKeySpecificData(true, true, false, 0, 0);
            FieldPointerSenseKeySpecificData[] fpArray = new FieldPointerSenseKeySpecificData[]{fp};
            ProtocolDataUnit responsePdu = ReadCapacityStage.createFixedFormatErrorPdu(fpArray, AdditionalSenseCodeAndQualifier.LOGICAL_BLOCK_ADDRESS_OUT_OF_RANGE, bhs.getInitiatorTaskTag(), parser.getExpectedDataTransferLength());
            this.connection.sendPdu(responsePdu);
            return;
        }
        ReadCapacityParameterData parameterData = cdb instanceof ReadCapacity10Cdb ? new ReadCapacity10ParameterData(this.session.getStorageModule().getSizeInBlocks(), this.session.getStorageModule().getBlockSize()) : new ReadCapacity16ParameterData(this.session.getStorageModule().getSizeInBlocks(), this.session.getStorageModule().getBlockSize());
        this.sendResponse(bhs.getInitiatorTaskTag(), parser.getExpectedDataTransferLength(), parameterData);
    }
}

