/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.target.connection.stage.fullfeature;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.jscsi.exception.InternetSCSIException;
import org.jscsi.parser.BasicHeaderSegment;
import org.jscsi.parser.ProtocolDataUnit;
import org.jscsi.parser.scsi.SCSICommandParser;
import org.jscsi.parser.scsi.SCSIResponseParser;
import org.jscsi.parser.scsi.SCSIStatus;
import org.jscsi.target.connection.TargetPduFactory;
import org.jscsi.target.connection.phase.TargetFullFeaturePhase;
import org.jscsi.target.connection.stage.fullfeature.ReadOrWriteStage;
import org.jscsi.target.scsi.ScsiResponseDataSegment;
import org.jscsi.target.scsi.cdb.Read10Cdb;
import org.jscsi.target.scsi.cdb.Read6Cdb;
import org.jscsi.target.scsi.cdb.ReadCdb;
import org.jscsi.target.scsi.cdb.ScsiOperationCode;
import org.jscsi.target.settings.SettingsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadStage
extends ReadOrWriteStage {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReadStage.class);

    public ReadStage(TargetFullFeaturePhase targetFullFeaturePhase) {
        super(targetFullFeaturePhase);
    }

    @Override
    public void execute(ProtocolDataUnit pdu) throws IOException, InterruptedException, InternetSCSIException, SettingsException {
        ProtocolDataUnit responsePdu;
        ReadCdb cdb;
        boolean immediateData = this.settings.getImmediateData();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("immediateData = " + immediateData);
            LOGGER.debug("maxRecvDataSegmentLength = " + this.settings.getMaxRecvDataSegmentLength());
        }
        BasicHeaderSegment bhs = pdu.getBasicHeaderSegment();
        SCSICommandParser parser = (SCSICommandParser)bhs.getParser();
        int initiatorTaskTag = bhs.getInitiatorTaskTag();
        ScsiOperationCode scsiOpCode = ScsiOperationCode.valueOf(parser.getCDB().get(0));
        if (scsiOpCode == ScsiOperationCode.READ_10) {
            cdb = new Read10Cdb(parser.getCDB());
        } else if (scsiOpCode == ScsiOperationCode.READ_6) {
            cdb = new Read6Cdb(parser.getCDB());
        } else {
            throw new InternetSCSIException("wrong SCSI Operation Code " + (Object)((Object)scsiOpCode) + " in ReadStage");
        }
        this.checkOverAndUnderflow(cdb);
        if (cdb.getIllegalFieldPointers() != null) {
            LOGGER.debug("illegal field in Read CDB");
            ProtocolDataUnit responsePdu2 = ReadStage.createFixedFormatErrorPdu(cdb.getIllegalFieldPointers(), initiatorTaskTag, parser.getExpectedDataTransferLength());
            this.connection.sendPdu(responsePdu2);
            return;
        }
        int totalTransferLength = this.session.getStorageModule().getBlockSize() * cdb.getTransferLength();
        long storageOffset = (long)this.session.getStorageModule().getBlockSize() * cdb.getLogicalBlockAddress();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("cdb.getLogicalBlockAddress() = " + cdb.getLogicalBlockAddress());
            LOGGER.debug("blockSize = " + this.session.getStorageModule().getBlockSize());
            LOGGER.debug("totalTransferLength = " + totalTransferLength);
            LOGGER.debug("expectedDataSegmentLength = " + parser.getExpectedDataTransferLength());
        }
        int bytesSent = 0;
        int dataSequenceNumber = 0;
        byte[] dataSegmentArray = null;
        ByteBuffer dataSegment = null;
        if (bytesSent < totalTransferLength - this.settings.getMaxRecvDataSegmentLength()) {
            dataSegmentArray = this.connection.getDataInArray(this.settings.getMaxRecvDataSegmentLength());
            dataSegment = ByteBuffer.wrap(dataSegmentArray);
        }
        while (bytesSent < totalTransferLength - this.settings.getMaxRecvDataSegmentLength()) {
            this.session.getStorageModule().read(dataSegmentArray, storageOffset + (long)bytesSent);
            responsePdu = TargetPduFactory.createDataInPdu(false, false, false, false, false, SCSIStatus.GOOD, 0L, initiatorTaskTag, -1, dataSequenceNumber, bytesSent, 0, dataSegment);
            this.connection.sendPdu(responsePdu);
            ++dataSequenceNumber;
            bytesSent += this.settings.getMaxRecvDataSegmentLength();
        }
        int bytesRemaining = totalTransferLength - bytesSent;
        dataSegmentArray = this.connection.getDataInArray(bytesRemaining);
        this.session.getStorageModule().read(dataSegmentArray, storageOffset + (long)bytesSent);
        dataSegment = ByteBuffer.wrap(dataSegmentArray);
        responsePdu = TargetPduFactory.createDataInPdu(true, false, false, false, immediateData, SCSIStatus.GOOD, 0L, initiatorTaskTag, -1, dataSequenceNumber, bytesSent, 0, dataSegment);
        LOGGER.debug("sending last Data-In PDU");
        this.connection.sendPdu(responsePdu);
        if (!immediateData) {
            responsePdu = TargetPduFactory.createSCSIResponsePdu(false, false, false, false, SCSIResponseParser.ServiceResponse.COMMAND_COMPLETED_AT_TARGET, SCSIStatus.GOOD, initiatorTaskTag, 0, 0, 0, 0, ScsiResponseDataSegment.EMPTY_DATA_SEGMENT);
            LOGGER.debug("sending SCSI Response PDU");
            this.connection.sendPdu(responsePdu);
        }
    }
}

