/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.target.connection.stage.fullfeature;

import java.io.IOException;
import java.security.DigestException;
import org.jscsi.exception.InternetSCSIException;
import org.jscsi.parser.BasicHeaderSegment;
import org.jscsi.parser.ProtocolDataUnit;
import org.jscsi.parser.scsi.SCSICommandParser;
import org.jscsi.target.connection.phase.TargetFullFeaturePhase;
import org.jscsi.target.connection.stage.fullfeature.TargetFullFeatureStage;
import org.jscsi.target.scsi.cdb.ReportLunsCDB;
import org.jscsi.target.scsi.cdb.SelectReport;
import org.jscsi.target.scsi.lun.ReportLunsParameterData;
import org.jscsi.target.scsi.sense.senseDataDescriptor.senseKeySpecific.FieldPointerSenseKeySpecificData;
import org.jscsi.target.settings.SettingsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportLunsStage
extends TargetFullFeatureStage {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportLunsStage.class);

    public ReportLunsStage(TargetFullFeaturePhase targetFullFeaturePhase) {
        super(targetFullFeaturePhase);
    }

    @Override
    public void execute(ProtocolDataUnit pdu) throws IOException, InterruptedException, InternetSCSIException, DigestException, SettingsException {
        BasicHeaderSegment bhs = pdu.getBasicHeaderSegment();
        SCSICommandParser parser = (SCSICommandParser)bhs.getParser();
        ReportLunsCDB cdb = new ReportLunsCDB(parser.getCDB());
        FieldPointerSenseKeySpecificData[] illegalFieldPointers = cdb.getIllegalFieldPointers();
        if (illegalFieldPointers != null) {
            ProtocolDataUnit responsePdu = ReportLunsStage.createFixedFormatErrorPdu(illegalFieldPointers, bhs.getInitiatorTaskTag(), parser.getExpectedDataTransferLength());
            this.connection.sendPdu(responsePdu);
        } else {
            ReportLunsParameterData reportLunsParameterData;
            SelectReport selectReport = cdb.getSelectReport();
            LOGGER.debug("selectReport = " + (Object)((Object)selectReport));
            switch (selectReport) {
                case SELECTED_ADDRESSING_METHODS: 
                case WELL_KNOWN_LUNS_ONLY: 
                case ALL: {
                    reportLunsParameterData = new ReportLunsParameterData(this.session.getTargetServer().getConfig().getLogicalUnitNumber());
                    break;
                }
                default: {
                    throw new InternetSCSIException();
                }
            }
            this.sendResponse(bhs.getInitiatorTaskTag(), parser.getExpectedDataTransferLength(), reportLunsParameterData);
        }
    }
}

