/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.target.connection.stage.fullfeature;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.jscsi.exception.InternetSCSIException;
import org.jscsi.parser.ProtocolDataUnit;
import org.jscsi.parser.scsi.SCSIResponseParser;
import org.jscsi.parser.scsi.SCSIStatus;
import org.jscsi.target.connection.TargetPduFactory;
import org.jscsi.target.connection.phase.TargetFullFeaturePhase;
import org.jscsi.target.connection.stage.TargetStage;
import org.jscsi.target.scsi.IResponseData;
import org.jscsi.target.scsi.ScsiResponseDataSegment;
import org.jscsi.target.scsi.sense.AdditionalSenseBytes;
import org.jscsi.target.scsi.sense.AdditionalSenseCodeAndQualifier;
import org.jscsi.target.scsi.sense.ErrorType;
import org.jscsi.target.scsi.sense.FixedFormatSenseData;
import org.jscsi.target.scsi.sense.SenseKey;
import org.jscsi.target.scsi.sense.information.FourByteInformation;
import org.jscsi.target.scsi.sense.senseDataDescriptor.senseKeySpecific.FieldPointerSenseKeySpecificData;

public abstract class TargetFullFeatureStage
extends TargetStage {
    public TargetFullFeatureStage(TargetFullFeaturePhase targetFullFeaturePhase) {
        super(targetFullFeaturePhase);
    }

    protected static final ProtocolDataUnit createFixedFormatErrorPdu(FieldPointerSenseKeySpecificData[] senseKeySpecificData, AdditionalSenseCodeAndQualifier additionalSenseCodeAndQualifier, int initiatorTaskTag, int expectedDataTransferLength) {
        FixedFormatSenseData senseData = new FixedFormatSenseData(false, ErrorType.CURRENT, false, false, false, SenseKey.ILLEGAL_REQUEST, new FourByteInformation(), new FourByteInformation(), additionalSenseCodeAndQualifier, 0, senseKeySpecificData[0], new AdditionalSenseBytes());
        ScsiResponseDataSegment dataSegment = new ScsiResponseDataSegment(senseData, expectedDataTransferLength);
        int senseDataSize = senseData.size();
        int residualCount = Math.abs(expectedDataTransferLength - senseDataSize);
        boolean residualOverflow = expectedDataTransferLength < senseDataSize;
        boolean residualUnderflow = expectedDataTransferLength > senseDataSize;
        return TargetPduFactory.createSCSIResponsePdu(false, false, residualOverflow, residualUnderflow, SCSIResponseParser.ServiceResponse.COMMAND_COMPLETED_AT_TARGET, SCSIStatus.CHECK_CONDITION, initiatorTaskTag, 0, 0, 0, residualCount, dataSegment);
    }

    protected static final ProtocolDataUnit createFixedFormatErrorPdu(FieldPointerSenseKeySpecificData[] senseKeySpecificData, int initiatorTaskTag, int expectedDataTransferLength) {
        return TargetFullFeatureStage.createFixedFormatErrorPdu(senseKeySpecificData, AdditionalSenseCodeAndQualifier.INVALID_FIELD_IN_CDB, initiatorTaskTag, expectedDataTransferLength);
    }

    protected static final ProtocolDataUnit createScsiResponsePdu(SCSIStatus status, int initiatorTaskTag, int expectedDataTransferLength, int responseDataSize) {
        int residualCount = Math.abs(expectedDataTransferLength - responseDataSize);
        boolean residualOverflow = expectedDataTransferLength < responseDataSize;
        boolean residualUnderflow = expectedDataTransferLength > responseDataSize;
        return TargetPduFactory.createSCSIResponsePdu(false, false, residualOverflow, residualUnderflow, SCSIResponseParser.ServiceResponse.COMMAND_COMPLETED_AT_TARGET, status, initiatorTaskTag, 0, 0, 0, residualCount, ScsiResponseDataSegment.EMPTY_DATA_SEGMENT);
    }

    protected final void sendResponse(int initiatorTaskTag, int expectedDataTransferLength, IResponseData responseData) throws InterruptedException, IOException, InternetSCSIException {
        ByteBuffer trimmedBuffer;
        ByteBuffer fullBuffer = ByteBuffer.allocate(responseData.size());
        responseData.serialize(fullBuffer, 0);
        if (fullBuffer.capacity() <= expectedDataTransferLength) {
            trimmedBuffer = fullBuffer;
        } else {
            trimmedBuffer = ByteBuffer.allocate(expectedDataTransferLength);
            trimmedBuffer.put(fullBuffer.array(), 0, expectedDataTransferLength);
        }
        boolean residualOverflow = expectedDataTransferLength < fullBuffer.capacity();
        boolean residualUnderflow = expectedDataTransferLength > fullBuffer.capacity();
        int residualCount = Math.abs(expectedDataTransferLength - fullBuffer.capacity());
        ProtocolDataUnit pdu = TargetPduFactory.createDataInPdu(true, false, residualOverflow, residualUnderflow, true, SCSIStatus.GOOD, 0L, initiatorTaskTag, -1, 0, 0, residualCount, trimmedBuffer);
        this.connection.sendPdu(pdu);
    }
}

