/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.target.connection.stage.fullfeature;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.DigestException;
import java.util.List;
import java.util.Vector;
import org.jscsi.exception.InternetSCSIException;
import org.jscsi.parser.BasicHeaderSegment;
import org.jscsi.parser.ProtocolDataUnit;
import org.jscsi.target.connection.TargetPduFactory;
import org.jscsi.target.connection.phase.TargetFullFeaturePhase;
import org.jscsi.target.connection.stage.fullfeature.TargetFullFeatureStage;
import org.jscsi.target.settings.SettingsException;
import org.jscsi.target.settings.TextParameter;
import org.jscsi.target.util.ReadWrite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TextNegotiationStage
extends TargetFullFeatureStage {
    private static final Logger LOGGER = LoggerFactory.getLogger(TextNegotiationStage.class);

    public TextNegotiationStage(TargetFullFeaturePhase targetFullFeaturePhase) {
        super(targetFullFeaturePhase);
    }

    @Override
    public void execute(ProtocolDataUnit pdu) throws IOException, InterruptedException, InternetSCSIException, DigestException, SettingsException {
        BasicHeaderSegment bhs = pdu.getBasicHeaderSegment();
        int initiatorTaskTag = bhs.getInitiatorTaskTag();
        String textRequest = new String(pdu.getDataSegment().array());
        LOGGER.debug("text request: " + textRequest);
        ByteBuffer replyDataSegment = null;
        List<String> requestKeyValuePairs = TextParameter.tokenizeKeyValuePairs(textRequest);
        Vector<String> responseKeyValuePairs = new Vector<String>();
        if (requestKeyValuePairs != null) {
            String sendTargetsValue = null;
            if (requestKeyValuePairs.size() == 1) {
                sendTargetsValue = TextParameter.getSuffix(requestKeyValuePairs.get(0), "SendTargets=");
            }
            if (sendTargetsValue != null) {
                boolean sendTargetAddress;
                boolean normal = this.session.isNormalSession();
                boolean sendTargetName = !normal && sendTargetsValue.equals("All");
                boolean bl = sendTargetAddress = !normal && sendTargetsValue.equals("All") || this.session.getTargetServer().isValidTargetName(sendTargetsValue) || normal && sendTargetsValue.length() == 0;
                if (sendTargetName) {
                    for (String curTargetName : this.session.getTargetServer().getTargetNames()) {
                        responseKeyValuePairs.add(TextParameter.toKeyValuePair("TargetName", curTargetName));
                        if (!sendTargetAddress) continue;
                        responseKeyValuePairs.add(TextParameter.toKeyValuePair("TargetAddress", this.session.getTargetServer().getConfig().getTargetAddress() + ":" + this.session.getTargetServer().getConfig().getPort() + "," + this.session.getTargetServer().getConfig().getTargetPortalGroupTag()));
                    }
                } else if (sendTargetAddress) {
                    responseKeyValuePairs.add(TextParameter.toKeyValuePair("TargetAddress", this.session.getTargetServer().getConfig().getTargetAddress() + ":" + this.session.getTargetServer().getConfig().getPort() + "," + this.session.getTargetServer().getConfig().getTargetPortalGroupTag()));
                }
            }
            String replyString = TextParameter.concatenateKeyValuePairs(responseKeyValuePairs);
            LOGGER.debug("text negotiation stage reply: " + replyString);
            replyDataSegment = ReadWrite.stringToTextDataSegments(replyString, this.settings.getMaxRecvDataSegmentLength())[0];
        }
        ProtocolDataUnit responsePdu = TargetPduFactory.createTextResponsePdu(true, false, 0L, initiatorTaskTag, -1, replyDataSegment);
        this.connection.sendPdu(responsePdu);
    }
}

