/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.target.connection.stage.fullfeature;

import java.io.IOException;
import java.security.DigestException;
import org.jscsi.exception.InternetSCSIException;
import org.jscsi.parser.AbstractMessageParser;
import org.jscsi.parser.BasicHeaderSegment;
import org.jscsi.parser.ProtocolDataUnit;
import org.jscsi.parser.data.DataOutParser;
import org.jscsi.parser.nop.NOPOutParser;
import org.jscsi.parser.scsi.SCSICommandParser;
import org.jscsi.parser.scsi.SCSIResponseParser;
import org.jscsi.parser.scsi.SCSIStatus;
import org.jscsi.target.TargetServer;
import org.jscsi.target.connection.TargetPduFactory;
import org.jscsi.target.connection.phase.TargetFullFeaturePhase;
import org.jscsi.target.connection.stage.fullfeature.ReadOrWriteStage;
import org.jscsi.target.scsi.ScsiResponseDataSegment;
import org.jscsi.target.scsi.cdb.ScsiOperationCode;
import org.jscsi.target.scsi.cdb.Write10Cdb;
import org.jscsi.target.scsi.cdb.Write6Cdb;
import org.jscsi.target.scsi.cdb.WriteCdb;
import org.jscsi.target.settings.SettingsException;
import org.jscsi.target.util.Debug;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WriteStage
extends ReadOrWriteStage {
    private static final Logger LOGGER = LoggerFactory.getLogger(WriteStage.class);
    private int expectedDataSequenceNumber = 0;

    public WriteStage(TargetFullFeaturePhase targetFullFeaturePhase) {
        super(targetFullFeaturePhase);
    }

    private void checkDataOutParser(AbstractMessageParser parser) throws InternetSCSIException {
        if (parser instanceof DataOutParser) {
            DataOutParser p = (DataOutParser)parser;
            if (p.getDataSequenceNumber() != this.expectedDataSequenceNumber++) {
                throw new InternetSCSIException("received erroneous PDU in data-out sequence, expected " + (this.expectedDataSequenceNumber - 1));
            }
        } else if (!(parser instanceof NOPOutParser) && !(parser instanceof SCSICommandParser)) {
            if (parser != null) {
                throw new InternetSCSIException("received erroneous PDU in data-out sequence, " + parser.getClass().getName());
            }
            throw new InternetSCSIException("received erroneous PDU in data-out sequence, parser is null");
        }
    }

    @Override
    public void execute(ProtocolDataUnit pdu) throws IOException, DigestException, InterruptedException, InternetSCSIException, SettingsException {
        WriteCdb cdb;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Entering WRITE STAGE");
        }
        boolean immediateData = this.settings.getImmediateData();
        boolean initialR2T = this.settings.getInitialR2T();
        int firstBurstLength = this.settings.getFirstBurstLength();
        int maxBurstLength = this.settings.getMaxBurstLength();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("immediateData = " + immediateData);
            LOGGER.debug("initialR2T = " + initialR2T);
        }
        BasicHeaderSegment bhs = pdu.getBasicHeaderSegment();
        SCSICommandParser parser = (SCSICommandParser)bhs.getParser();
        int initiatorTaskTag = bhs.getInitiatorTaskTag();
        ScsiOperationCode scsiOpCode = ScsiOperationCode.valueOf(parser.getCDB().get(0));
        if (scsiOpCode == ScsiOperationCode.WRITE_10) {
            cdb = new Write10Cdb(parser.getCDB());
        } else if (scsiOpCode == ScsiOperationCode.WRITE_6) {
            cdb = new Write6Cdb(parser.getCDB());
        } else {
            throw new InternetSCSIException("wrong SCSI Operation Code " + (Object)((Object)scsiOpCode) + " in WriteStage");
        }
        int transferLength = cdb.getTransferLength();
        long logicalBlockAddress = cdb.getLogicalBlockAddress();
        int transferLengthInBytes = transferLength * this.session.getStorageModule().getBlockSize();
        long storageIndex = logicalBlockAddress * (long)this.session.getStorageModule().getBlockSize();
        this.checkOverAndUnderflow(cdb);
        if (cdb.getIllegalFieldPointers() != null) {
            LOGGER.debug("illegal field in Write CDB");
            LOGGER.debug("CDB:\n" + Debug.byteBufferToString(parser.getCDB()));
            ProtocolDataUnit responsePdu = WriteStage.createFixedFormatErrorPdu(cdb.getIllegalFieldPointers(), initiatorTaskTag, parser.getExpectedDataTransferLength());
            this.connection.sendPdu(responsePdu);
            return;
        }
        int bytesReceived = 0;
        if (immediateData && bhs.getDataSegmentLength() > 0) {
            byte[] immediateDataArray = pdu.getDataSegment().array();
            this.session.getStorageModule().write(immediateDataArray, storageIndex);
            bytesReceived = immediateDataArray.length;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("wrote " + immediateDataArray.length + "bytes as immediate data");
            }
        }
        if (!initialR2T && !bhs.isFinalFlag()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("receiving unsolicited data");
            }
            boolean firstBurstOver = false;
            while (!firstBurstOver && bytesReceived <= firstBurstLength) {
                pdu = this.connection.receivePdu();
                bhs = pdu.getBasicHeaderSegment();
                this.checkDataOutParser(bhs.getParser());
                DataOutParser dataOutParser = (DataOutParser)bhs.getParser();
                this.session.getStorageModule().write(pdu.getDataSegment().array(), storageIndex + (long)dataOutParser.getBufferOffset());
                bytesReceived += bhs.getDataSegmentLength();
                if (!bhs.isFinalFlag()) continue;
                firstBurstOver = true;
            }
        }
        if (bytesReceived < transferLengthInBytes) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(bytesReceived + "<" + transferLengthInBytes);
            }
            int readyToTransferSequenceNumber = 0;
            while (bytesReceived < transferLengthInBytes) {
                int desiredDataTransferLength = Math.min(maxBurstLength, transferLengthInBytes - bytesReceived);
                pdu = TargetPduFactory.createReadyToTransferPdu(0L, initiatorTaskTag, TargetServer.getNextTargetTransferTag(), readyToTransferSequenceNumber++, bytesReceived, desiredDataTransferLength);
                this.connection.sendPdu(pdu);
                this.expectedDataSequenceNumber = 0;
                boolean solicitedDataCycleOver = false;
                int bytesReceivedThisCycle = 0;
                while (!solicitedDataCycleOver) {
                    pdu = this.connection.receivePdu();
                    bhs = pdu.getBasicHeaderSegment();
                    this.checkDataOutParser(bhs.getParser());
                    if (bhs.getParser() instanceof NOPOutParser) {
                        pdu = TargetPduFactory.createSCSIResponsePdu(false, false, false, false, SCSIResponseParser.ServiceResponse.COMMAND_COMPLETED_AT_TARGET, SCSIStatus.GOOD, initiatorTaskTag, 0, 0, 0, 0, ScsiResponseDataSegment.EMPTY_DATA_SEGMENT);
                        this.connection.sendPdu(pdu);
                        return;
                    }
                    if (!(bhs.getParser() instanceof DataOutParser)) continue;
                    DataOutParser dataOutParser = (DataOutParser)bhs.getParser();
                    this.session.getStorageModule().write(pdu.getDataSegment().array(), storageIndex + (long)dataOutParser.getBufferOffset());
                    if (!bhs.isFinalFlag() && (bytesReceivedThisCycle += bhs.getDataSegmentLength()) < desiredDataTransferLength) continue;
                    solicitedDataCycleOver = true;
                }
                bytesReceived += bytesReceivedThisCycle;
            }
        }
        pdu = TargetPduFactory.createSCSIResponsePdu(false, false, false, false, SCSIResponseParser.ServiceResponse.COMMAND_COMPLETED_AT_TARGET, SCSIStatus.GOOD, initiatorTaskTag, 0, 0, 0, 0, ScsiResponseDataSegment.EMPTY_DATA_SEGMENT);
        this.connection.sendPdu(pdu);
    }
}

