/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.target.connection.stage.login;

import java.io.IOException;
import java.security.DigestException;
import java.util.List;
import java.util.Vector;
import org.jscsi.exception.InternetSCSIException;
import org.jscsi.parser.BasicHeaderSegment;
import org.jscsi.parser.ProtocolDataUnit;
import org.jscsi.parser.login.LoginStage;
import org.jscsi.parser.login.LoginStatus;
import org.jscsi.target.connection.phase.TargetLoginPhase;
import org.jscsi.target.connection.stage.login.TargetLoginStage;
import org.jscsi.target.settings.SettingsException;
import org.jscsi.target.settings.TextParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LoginOperationalParameterNegotiationStage
extends TargetLoginStage {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoginOperationalParameterNegotiationStage.class);

    public LoginOperationalParameterNegotiationStage(TargetLoginPhase targetLoginPhase) {
        super(targetLoginPhase, LoginStage.LOGIN_OPERATIONAL_NEGOTIATION);
    }

    @Override
    public void execute(ProtocolDataUnit pdu) throws IOException, InterruptedException, InternetSCSIException, DigestException, IllegalArgumentException, SettingsException {
        LOGGER.debug("Entering LOPN Stage");
        BasicHeaderSegment bhs = pdu.getBasicHeaderSegment();
        this.initiatorTaskTag = bhs.getInitiatorTaskTag();
        String keyValuePairProposal = this.receivePduSequence(pdu);
        List<String> requestKeyValuePairs = TextParameter.tokenizeKeyValuePairs(keyValuePairProposal);
        Vector<String> responseKeyValuePairs = new Vector<String>();
        if (!this.negotiator.negotiate(this.session.getTargetServer(), this.stageNumber, this.connection.isLeadingConnection(), ((TargetLoginPhase)this.targetPhase).getFirstPduAndSetToFalse(), requestKeyValuePairs, responseKeyValuePairs)) {
            this.sendRejectPdu(LoginStatus.INITIATOR_ERROR);
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("request: ");
            for (String s : requestKeyValuePairs) {
                sb.append("\n  ");
                sb.append(s);
            }
            sb.append("\nresponse: ");
            for (String s : responseKeyValuePairs) {
                sb.append("\n  ");
                sb.append(s);
            }
            LOGGER.debug(sb.toString());
        }
        if (this.requestedNextStageNumber != LoginStage.FULL_FEATURE_PHASE) {
            this.sendRejectPdu(LoginStatus.INITIATOR_ERROR);
            throw new InternetSCSIException();
        }
        String keyValuePairReply = TextParameter.concatenateKeyValuePairs(responseKeyValuePairs);
        this.sendPduSequence(keyValuePairReply, LoginStage.FULL_FEATURE_PHASE);
        this.negotiator.finishNegotiation(true);
        this.nextStageNumber = LoginStage.FULL_FEATURE_PHASE;
    }
}

