/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.target.connection.stage.login;

import java.io.IOException;
import java.security.DigestException;
import java.util.List;
import java.util.Vector;
import org.jscsi.exception.InternetSCSIException;
import org.jscsi.parser.BasicHeaderSegment;
import org.jscsi.parser.ProtocolDataUnit;
import org.jscsi.parser.login.LoginStage;
import org.jscsi.parser.login.LoginStatus;
import org.jscsi.target.connection.phase.TargetLoginPhase;
import org.jscsi.target.connection.stage.login.TargetLoginStage;
import org.jscsi.target.settings.SettingsException;
import org.jscsi.target.settings.TextParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SecurityNegotiationStage
extends TargetLoginStage {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecurityNegotiationStage.class);

    public SecurityNegotiationStage(TargetLoginPhase targetLoginPhase) {
        super(targetLoginPhase, LoginStage.SECURITY_NEGOTIATION);
    }

    @Override
    public void execute(ProtocolDataUnit initialPdu) throws IOException, InterruptedException, InternetSCSIException, DigestException, SettingsException {
        BasicHeaderSegment bhs = initialPdu.getBasicHeaderSegment();
        this.initiatorTaskTag = bhs.getInitiatorTaskTag();
        boolean authenticated = false;
        do {
            String requestTextParameters = this.receivePduSequence(initialPdu);
            List<String> requestKeyValuePairs = TextParameter.tokenizeKeyValuePairs(requestTextParameters);
            Vector<String> authMethodKeyValuePairs = new Vector<String>();
            if (LOGGER.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("request key value pairs:\n");
                for (String s : requestKeyValuePairs) {
                    sb.append("   " + s + "\n");
                }
                LOGGER.debug(sb.toString());
            }
            String authMethodValues = null;
            if (!authenticated) {
                for (int i = 0; i < requestKeyValuePairs.size(); ++i) {
                    String[] split = TextParameter.splitKeyValuePair(requestKeyValuePairs.get(i));
                    if (split == null) {
                        this.sendRejectPdu(LoginStatus.INITIATOR_ERROR);
                        throw new InternetSCSIException("key=value format error: " + requestKeyValuePairs.get(i));
                    }
                    if ("AuthMethod".equals(split[0])) {
                        authMethodValues = split[1];
                        requestKeyValuePairs.remove(i--);
                        continue;
                    }
                    if (!this.isAuthenticationKey(split[0])) continue;
                    authMethodKeyValuePairs.add(requestKeyValuePairs.remove(i--));
                }
                if (authMethodValues == null) {
                    this.sendRejectPdu(LoginStatus.MISSING_PARAMETER);
                    throw new InternetSCSIException("Missing AuthMethod key-value pair");
                }
            }
            Vector<String> responseKeyValuePairs = new Vector<String>();
            if (!this.negotiator.negotiate(this.session.getTargetServer(), this.stageNumber, this.connection.isLeadingConnection(), ((TargetLoginPhase)this.targetPhase).getFirstPduAndSetToFalse(), requestKeyValuePairs, responseKeyValuePairs)) {
                this.sendRejectPdu(LoginStatus.INITIATOR_ERROR);
                throw new InternetSCSIException("negotiation failure");
            }
            if (authenticated) continue;
            if (authMethodValues.contains("None")) {
                authenticated = true;
                responseKeyValuePairs.add(TextParameter.toKeyValuePair("AuthMethod", "None"));
                String responseString = TextParameter.concatenateKeyValuePairs(responseKeyValuePairs);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("response: " + responseString);
                }
                this.sendPduSequence(responseString, this.requestedNextStageNumber);
                if (this.requestedNextStageNumber != LoginStage.LOGIN_OPERATIONAL_NEGOTIATION && this.requestedNextStageNumber != LoginStage.FULL_FEATURE_PHASE) continue;
                this.nextStageNumber = this.requestedNextStageNumber;
                return;
            }
            LOGGER.error("initiator attempted CHAP authentication");
            return;
        } while (!bhs.isFinalFlag() && !authenticated);
    }

    private final boolean isAuthenticationKey(String key) {
        if (key == null || key.length() < 5) {
            return false;
        }
        String fourChars = key.substring(0, 4);
        String fiveChars = key.substring(0, 5);
        return "CHAP_".matches(fiveChars) || "KRB_".matches(fourChars) || "SPKM_".matches(fiveChars) || "SRP_".matches(fourChars) || key.length() >= 10 && "TargetAuth".matches(key.substring(0, 10));
    }
}

