/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.target.connection.stage.login;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.DigestException;
import org.jscsi.exception.InternetSCSIException;
import org.jscsi.parser.BasicHeaderSegment;
import org.jscsi.parser.OperationCode;
import org.jscsi.parser.ProtocolDataUnit;
import org.jscsi.parser.login.LoginRequestParser;
import org.jscsi.parser.login.LoginStage;
import org.jscsi.parser.login.LoginStatus;
import org.jscsi.target.connection.TargetPduFactory;
import org.jscsi.target.connection.phase.TargetLoginPhase;
import org.jscsi.target.connection.stage.TargetStage;
import org.jscsi.target.settings.ConnectionSettingsNegotiator;
import org.jscsi.target.settings.SettingsException;
import org.jscsi.target.util.ReadWrite;

public abstract class TargetLoginStage
extends TargetStage {
    protected final ConnectionSettingsNegotiator negotiator;
    protected final LoginStage stageNumber;
    protected int initiatorTaskTag;
    protected LoginStage requestedNextStageNumber;
    protected LoginStage nextStageNumber;

    public TargetLoginStage(TargetLoginPhase targetLoginPhase, LoginStage stageNumber) {
        super(targetLoginPhase);
        this.stageNumber = stageNumber;
        this.negotiator = this.connection.getConnectionSettingsNegotiator();
    }

    protected boolean checkPdu(ProtocolDataUnit pdu) {
        BasicHeaderSegment bhs = pdu.getBasicHeaderSegment();
        LoginRequestParser parser = (LoginRequestParser)bhs.getParser();
        return bhs.getOpCode() == OperationCode.LOGIN_REQUEST && parser.getCurrentStageNumber() == this.stageNumber && bhs.getInitiatorTaskTag() == this.initiatorTaskTag;
    }

    protected final String receivePduSequence() throws DigestException, InternetSCSIException, IOException, SettingsException, InterruptedException {
        ProtocolDataUnit pdu = this.connection.receivePdu();
        return this.receivePduSequence(pdu);
    }

    protected final String receivePduSequence(ProtocolDataUnit pdu) throws InternetSCSIException, InterruptedException, IOException, DigestException, SettingsException {
        StringBuilder stringBuilder = new StringBuilder();
        int sequenceLength = 1;
        while (sequenceLength <= this.session.getTargetServer().getConfig().getInMaxRecvTextPduSequenceLength()) {
            BasicHeaderSegment bhs = pdu.getBasicHeaderSegment();
            LoginRequestParser parser = (LoginRequestParser)bhs.getParser();
            if (!this.checkPdu(pdu)) {
                this.sendRejectPdu(LoginStatus.INVALID_DURING_LOGIN);
                throw new InternetSCSIException("Wrong PDU in TargetLoginStage");
            }
            ReadWrite.appendTextDataSegmentToStringBuffer(pdu.getDataSegment(), stringBuilder);
            this.requestedNextStageNumber = parser.getNextStageNumber();
            if (parser.isContinueFlag()) {
                pdu = TargetPduFactory.createLoginResponsePdu(false, false, this.stageNumber, this.stageNumber, this.session.getInitiatorSessionID(), this.session.getTargetSessionIdentifyingHandle(), this.initiatorTaskTag, LoginStatus.SUCCESS, ByteBuffer.allocate(0));
                this.connection.sendPdu(pdu);
                pdu = this.connection.receivePdu();
                continue;
            }
            return stringBuilder.toString();
        }
        this.sendRejectPdu(LoginStatus.OUT_OF_RESOURCES);
        throw new InternetSCSIException("Wrong PDU in TargetLoginStage");
    }

    protected final void sendPduSequence(String keyValuePairs, LoginStage nextStage) throws SettingsException, InterruptedException, IOException, InternetSCSIException, DigestException {
        boolean continueFlag = true;
        boolean transitFlag = false;
        ByteBuffer[] dataSegments = ReadWrite.stringToTextDataSegments(keyValuePairs, this.settings.getMaxRecvDataSegmentLength());
        for (int i = 0; i < dataSegments.length; ++i) {
            if (i == dataSegments.length - 1) {
                continueFlag = false;
                if (this.stageNumber != nextStage) {
                    transitFlag = true;
                }
            }
            ProtocolDataUnit pdu = TargetPduFactory.createLoginResponsePdu(transitFlag, continueFlag, this.stageNumber, nextStage, this.session.getInitiatorSessionID(), this.session.getTargetSessionIdentifyingHandle(), this.initiatorTaskTag, LoginStatus.SUCCESS, dataSegments[i]);
            this.connection.sendPdu(pdu);
            if (!continueFlag) continue;
            pdu = this.connection.receivePdu();
            BasicHeaderSegment bhs = pdu.getBasicHeaderSegment();
            LoginRequestParser parser = (LoginRequestParser)bhs.getParser();
            if (this.checkPdu(pdu) && !parser.isContinueFlag()) continue;
            this.sendRejectPdu(LoginStatus.INITIATOR_ERROR);
            throw new InternetSCSIException();
        }
    }

    protected final void sendRejectPdu(LoginStatus errorStatus) throws InterruptedException, IOException, InternetSCSIException {
        ProtocolDataUnit rejectPDU = TargetPduFactory.createLoginResponsePdu(false, false, this.stageNumber, this.stageNumber, this.session.getInitiatorSessionID(), this.session.getTargetSessionIdentifyingHandle(), this.initiatorTaskTag, errorStatus, ByteBuffer.allocate(0));
        this.connection.sendPdu(rejectPDU);
    }

    public final LoginStage getNextStageNumber() {
        return this.nextStageNumber;
    }
}

