/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.target.scsi;

import java.nio.ByteBuffer;
import org.jscsi.target.scsi.IResponseData;
import org.jscsi.target.scsi.sense.SenseData;
import org.jscsi.target.util.Debug;
import org.jscsi.target.util.ReadWrite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ScsiResponseDataSegment {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScsiResponseDataSegment.class);
    public static final ScsiResponseDataSegment EMPTY_DATA_SEGMENT = new ScsiResponseDataSegment();
    private static final int SENSE_LENGTH_FIELD_LENGTH = 2;
    private final SenseData senseData;
    private final IResponseData responseData;
    private final int allocationLength;
    private int uncroppedSize = -1;

    private ScsiResponseDataSegment() {
        this(null, null, 0);
    }

    public ScsiResponseDataSegment(SenseData senseData, int allocationLength) {
        this(senseData, null, allocationLength);
    }

    public ScsiResponseDataSegment(IResponseData responseData, int allocationLength) {
        this(null, responseData, allocationLength);
    }

    private ScsiResponseDataSegment(SenseData senseData, IResponseData responseData, int allocationLength) {
        this.senseData = senseData;
        this.responseData = responseData;
        this.allocationLength = allocationLength;
    }

    public ByteBuffer serialize() {
        int size = this.uncroppedSize();
        if (size == 0) {
            return ByteBuffer.allocate(0);
        }
        int senseLength = this.senseData == null ? 0 : this.senseData.size();
        ByteBuffer buffer = ByteBuffer.allocate(size);
        ReadWrite.writeTwoByteInt(buffer, senseLength, 0);
        if (this.senseData != null) {
            this.senseData.serialize(buffer, 2);
        }
        if (this.responseData != null) {
            this.responseData.serialize(buffer, 2 + senseLength);
        }
        if (this.allocationLength > 0 && buffer.capacity() > this.allocationLength) {
            buffer.position(0);
            buffer.limit(this.allocationLength);
            ByteBuffer croppedBuffer = ByteBuffer.allocate(this.allocationLength);
            croppedBuffer.put(buffer);
            return croppedBuffer;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("SCSI Response Data Segment:\n" + Debug.byteBufferToString(buffer));
        }
        return buffer;
    }

    public int uncroppedSize() {
        if (this.uncroppedSize < 0) {
            if (this.senseData == null && this.responseData == null) {
                return 0;
            }
            int size = 2;
            if (this.senseData != null) {
                size += this.senseData.size();
            }
            if (this.responseData != null) {
                size += this.responseData.size();
            }
            this.uncroppedSize = size;
        }
        return this.uncroppedSize;
    }

    public boolean getResidualOverflow() {
        return this.uncroppedSize() > this.allocationLength;
    }

    public int getResidualCount() {
        if (this.getResidualOverflow()) {
            return this.uncroppedSize() - this.allocationLength;
        }
        return 0;
    }
}

