/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.target.scsi.cdb;

import java.nio.ByteBuffer;
import org.jscsi.target.scsi.cdb.CdbType;
import org.jscsi.target.scsi.cdb.ScsiOperationCode;
import org.jscsi.target.scsi.sense.senseDataDescriptor.senseKeySpecific.FieldPointerSenseKeySpecificData;
import org.jscsi.target.util.BitManip;

public abstract class CommandDescriptorBlock {
    private FieldPointerSenseKeySpecificData[] illegalFieldPointers = null;
    private ScsiOperationCode scsiOperationCode;
    private boolean normalAutoContingentAllegiance;

    public CommandDescriptorBlock(ByteBuffer buffer) {
        int controlByteIndex;
        this.scsiOperationCode = ScsiOperationCode.valueOf(buffer.get(0));
        if (this.scsiOperationCode == null) {
            this.addIllegalFieldPointer(0);
        }
        CdbType cdbType = this.scsiOperationCode.getCdbType();
        switch (cdbType) {
            case SIX_BYTE_COMMANDS: {
                controlByteIndex = 5;
                break;
            }
            case TEN_BYTE_COMMANDS: {
                controlByteIndex = 9;
                break;
            }
            case TWELVE_BYTE_COMMANDS: {
                controlByteIndex = 11;
                break;
            }
            case SIXTEEN_BYTE_COMMANDS: {
                controlByteIndex = 15;
                break;
            }
            default: {
                controlByteIndex = -1;
            }
        }
        this.normalAutoContingentAllegiance = BitManip.getBit(buffer.get(controlByteIndex), 2);
        if (this.normalAutoContingentAllegiance) {
            this.addIllegalFieldPointer(controlByteIndex, 2);
        }
    }

    public final ScsiOperationCode getScsiOperationCode() {
        return this.scsiOperationCode;
    }

    public final boolean isNormalACA() {
        return this.normalAutoContingentAllegiance;
    }

    protected final void addIllegalFieldPointer(int byteNumber) {
        FieldPointerSenseKeySpecificData fp = new FieldPointerSenseKeySpecificData(true, true, false, 0, byteNumber);
        this.addIllegalFieldPointer(fp);
    }

    protected final void addIllegalFieldPointer(int byteNumber, int bitNumber) {
        FieldPointerSenseKeySpecificData fp = new FieldPointerSenseKeySpecificData(true, true, true, bitNumber, byteNumber);
        this.addIllegalFieldPointer(fp);
    }

    private final void addIllegalFieldPointer(FieldPointerSenseKeySpecificData illegalFieldPointer) {
        int size;
        if (this.illegalFieldPointers == null) {
            this.illegalFieldPointers = new FieldPointerSenseKeySpecificData[10];
        }
        if ((size = this.getIllegalFieldPointerSize()) >= this.illegalFieldPointers.length) {
            FieldPointerSenseKeySpecificData[] temp = new FieldPointerSenseKeySpecificData[this.illegalFieldPointers.length + 1];
            for (int i = 0; i < size; ++i) {
                temp[i] = this.illegalFieldPointers[i];
            }
            this.illegalFieldPointers = temp;
        }
        this.illegalFieldPointers[size] = illegalFieldPointer;
    }

    private final int getIllegalFieldPointerSize() {
        int size;
        if (this.illegalFieldPointers == null) {
            return 0;
        }
        for (size = 0; size < this.illegalFieldPointers.length && this.illegalFieldPointers[size] != null; ++size) {
        }
        return size;
    }

    public final FieldPointerSenseKeySpecificData[] getIllegalFieldPointers() {
        if (this.illegalFieldPointers == null) {
            return null;
        }
        int size = this.getIllegalFieldPointerSize();
        FieldPointerSenseKeySpecificData[] result = new FieldPointerSenseKeySpecificData[size];
        for (int i = 0; i < size; ++i) {
            result[i] = this.illegalFieldPointers[i];
        }
        return result;
    }
}

