/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.target.scsi.cdb;

import java.nio.ByteBuffer;
import org.jscsi.target.scsi.cdb.CommandDescriptorBlock;
import org.jscsi.target.scsi.cdb.DefectListFormat;
import org.jscsi.target.util.BitManip;

public final class FormatUnitCDB
extends CommandDescriptorBlock {
    private byte formatProtectionInformation;
    private boolean longList;
    private boolean formatData;
    private boolean completeList;
    private DefectListFormat defectListFormat;

    public FormatUnitCDB(ByteBuffer buffer) {
        super(buffer);
        byte b = buffer.get(1);
        this.formatProtectionInformation = (byte)(b >>> 6);
        this.longList = BitManip.getBit(b, 5);
        this.formatData = BitManip.getBit(b, 4);
        this.completeList = BitManip.getBit(b, 3);
        this.defectListFormat = DefectListFormat.valueOf(b & 7);
        if (!this.formatData) {
            if (this.defectListFormat != DefectListFormat.SHORT_BLOCK) {
                this.addIllegalFieldPointer(1, 2);
            }
            if (this.formatProtectionInformation != 0) {
                this.addIllegalFieldPointer(1, 7);
            }
        } else if (this.formatData) {
            this.addIllegalFieldPointer(1, 4);
        }
    }

    public final boolean getCompleteList() {
        return this.completeList;
    }

    public final int getFormatProtectionInformation() {
        return this.formatProtectionInformation;
    }

    public final boolean getLongList() {
        return this.longList;
    }
}

