/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.target.scsi.cdb;

import java.nio.ByteBuffer;
import org.jscsi.target.scsi.cdb.CommandDescriptorBlock;
import org.jscsi.target.scsi.inquiry.PageCode;
import org.jscsi.target.scsi.inquiry.SupportedVpdPages;
import org.jscsi.target.util.BitManip;
import org.jscsi.target.util.ReadWrite;

public class InquiryCDB
extends CommandDescriptorBlock {
    private final boolean enableVitalProductData;
    private final int allocationLength;
    private final PageCode pageCode;

    public InquiryCDB(ByteBuffer buffer) {
        super(buffer);
        this.enableVitalProductData = BitManip.getBit(buffer.get(1), 0);
        this.pageCode = new PageCode(buffer.get(2));
        this.allocationLength = ReadWrite.readTwoByteInt(buffer, 3);
        PageCode.VitalProductDataPageName vpdpn = this.pageCode.getVitalProductDataPageName();
        if (this.enableVitalProductData) {
            if (!SupportedVpdPages.vpdPageCodeSupported(vpdpn)) {
                this.addIllegalFieldPointer(2);
            }
        } else if (vpdpn != PageCode.VitalProductDataPageName.SUPPORTED_VPD_PAGES) {
            this.addIllegalFieldPointer(2);
        }
    }

    public boolean getEnableVitalProductData() {
        return this.enableVitalProductData;
    }

    public PageCode getPageCode() {
        return this.pageCode;
    }

    public int getAllocationLength() {
        return this.allocationLength;
    }
}

