/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.target.scsi.cdb;

import java.nio.ByteBuffer;
import org.jscsi.target.scsi.cdb.CommandDescriptorBlock;
import org.jscsi.target.scsi.modeSense.ModePageCode;
import org.jscsi.target.scsi.modeSense.PageControl;
import org.jscsi.target.util.BitManip;
import org.jscsi.target.util.ReadWrite;

public final class ModeSense6Cdb
extends CommandDescriptorBlock {
    private final boolean disableBlockDescriptors;
    private final PageControl pageControl;
    private final int pageCode;
    private final int subpageCode;
    private final int allocationLength;

    public ModeSense6Cdb(ByteBuffer buffer) {
        super(buffer);
        this.disableBlockDescriptors = BitManip.getBit(buffer.get(1), 3);
        int i = buffer.get(2) >> 6 & 3;
        this.pageControl = PageControl.getPageControl(i);
        this.pageCode = buffer.get(2) & 0x3F;
        this.subpageCode = ReadWrite.readOneByteInt(buffer, 3);
        this.allocationLength = ReadWrite.readOneByteInt(buffer, 4);
    }

    public boolean getDisableBlockDescriptors() {
        return this.disableBlockDescriptors;
    }

    public PageControl getPageControl() {
        return this.pageControl;
    }

    public int getPageCode() {
        return this.pageCode;
    }

    public int getSubpageCode() {
        return this.subpageCode;
    }

    public int getAllocationLength() {
        return this.allocationLength;
    }

    public ModePageCode getModePage() {
        return ModePageCode.getModePage(this.pageCode, this.subpageCode);
    }
}

