/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.target.scsi.cdb;

import java.nio.ByteBuffer;
import org.jscsi.target.scsi.cdb.ReadCapacityCdb;
import org.jscsi.target.util.BitManip;

public class ReadCapacity16Cdb
extends ReadCapacityCdb {
    private static final byte SERVICE_ACTION = 16;
    private final byte serviceAction;

    public ReadCapacity16Cdb(ByteBuffer buffer) {
        super(buffer);
        this.serviceAction = (byte)(buffer.get(1) & 0x1F);
        if (this.serviceAction != 16) {
            this.addIllegalFieldPointer(1, 4);
        }
    }

    @Override
    protected long deserializeLogicalBlockAddress(ByteBuffer buffer) {
        return buffer.getLong(2);
    }

    @Override
    protected boolean deserializePartialMediumIndicator(ByteBuffer buffer) {
        return BitManip.getBit(buffer.get(14), 0);
    }

    public byte getServiceAction() {
        return this.serviceAction;
    }
}

