/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.target.scsi.cdb;

import java.nio.ByteBuffer;
import org.jscsi.target.scsi.cdb.CommandDescriptorBlock;
import org.jscsi.target.scsi.cdb.SelfTestCode;
import org.jscsi.target.util.BitManip;
import org.jscsi.target.util.ReadWrite;

public final class SendDiagnosticCdb
extends CommandDescriptorBlock {
    private final SelfTestCode selfTestCode;
    private final boolean selfTest;
    private final boolean pageFormat;
    private final boolean unitOffline;
    private final boolean deviceOffline;
    private final short parameterListLength;

    public SendDiagnosticCdb(ByteBuffer buffer) {
        super(buffer);
        byte b = buffer.get(1);
        this.selfTest = BitManip.getBit(b, 2);
        if (!this.selfTest) {
            this.addIllegalFieldPointer(1, 2);
        }
        this.selfTestCode = SelfTestCode.getValue(b >>> 5);
        if (this.selfTest && this.selfTestCode != SelfTestCode.ALL_ZEROS) {
            this.addIllegalFieldPointer(1, 7);
        }
        this.pageFormat = BitManip.getBit(b, 4);
        if (this.pageFormat) {
            this.addIllegalFieldPointer(1, 4);
        }
        this.deviceOffline = BitManip.getBit(b, 1);
        this.unitOffline = BitManip.getBit(b, 0);
        this.parameterListLength = (short)ReadWrite.readTwoByteInt(buffer, 3);
    }

    public final boolean getSelfTest() {
        return this.selfTest;
    }

    public final SelfTestCode getSelfTestCode() {
        return this.selfTestCode;
    }

    public final boolean getPageFormat() {
        return this.pageFormat;
    }

    public final boolean getUnitOffline() {
        return this.unitOffline;
    }

    public final boolean getDeviceOffline() {
        return this.deviceOffline;
    }

    public final short getParameterListLength() {
        return this.parameterListLength;
    }
}

