/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.target.scsi.cdb;

import java.nio.ByteBuffer;
import org.jscsi.target.scsi.cdb.WriteCdb;
import org.jscsi.target.util.BitManip;
import org.jscsi.target.util.ReadWrite;

public class Write10Cdb
extends WriteCdb {
    private final int writeProtect;
    private final boolean disablePageOut;
    private final boolean forceUnitAccess;
    private final boolean forceUnitAccessNonVolatileCache;
    private final int groupNumber;

    public Write10Cdb(ByteBuffer buffer) {
        super(buffer);
        byte b = buffer.get(1);
        this.writeProtect = b >> 5 & 7;
        this.disablePageOut = BitManip.getBit(b, 4);
        this.forceUnitAccess = BitManip.getBit(b, 3);
        this.forceUnitAccessNonVolatileCache = BitManip.getBit(b, 1);
        b = buffer.get(6);
        this.groupNumber = b & 0x1F;
    }

    @Override
    protected long deserializeLogicalBlockAddress(ByteBuffer buffer) {
        return ReadWrite.readUnsignedInt(buffer, 2);
    }

    @Override
    protected int deserializeTransferLength(ByteBuffer buffer) {
        return ReadWrite.readTwoByteInt(buffer, 7);
    }

    public int getWriteProtect() {
        return this.writeProtect;
    }

    public boolean disablePageOut() {
        return this.disablePageOut;
    }

    public boolean getForceUnitAccess() {
        return this.forceUnitAccess;
    }

    public boolean getForceUnitAccessNonVolatile() {
        return this.forceUnitAccessNonVolatileCache;
    }

    public int getGroupNumber() {
        return this.groupNumber;
    }

    @Override
    protected int getLogicalBlockAddressFieldIndex() {
        return 2;
    }

    @Override
    protected int getTransferLengthFieldIndex() {
        return 7;
    }
}

