/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.target.scsi.inquiry;

import java.nio.ByteBuffer;
import org.jscsi.target.TargetServer;
import org.jscsi.target.scsi.IResponseData;
import org.jscsi.target.scsi.inquiry.Association;
import org.jscsi.target.scsi.inquiry.CodeSet;
import org.jscsi.target.scsi.inquiry.IdentificationDescriptor;
import org.jscsi.target.scsi.inquiry.IdentifierType;
import org.jscsi.target.scsi.inquiry.ProtocolIdentifier;
import org.jscsi.target.scsi.inquiry.ScsiNameStringIdentifier;
import org.jscsi.target.util.ReadWrite;

public class DeviceIdentificationVpdPage
implements IResponseData {
    private static final int HEADER_LENGTH = 4;
    private static final int PAGE_LENGTH_FIELD_INDEX = 2;
    private final byte peripheralQualifierAndPeripheralDeviceType = 0;
    private final byte pageCode = (byte)-125;
    private IdentificationDescriptor[] identificationDescriptors = new IdentificationDescriptor[0];

    public DeviceIdentificationVpdPage(TargetServer target) {
        ProtocolIdentifier protocolIdentifier = ProtocolIdentifier.INTERNET_SCSI;
        CodeSet codeSet = CodeSet.UTF8_CODES;
        boolean protocolIdentifierValid = true;
        Association association = Association.SCSI_TARGET_DEVICE;
        IdentifierType identifierType = IdentifierType.SCSI_NAME_STRING;
        String[] targetNames = target.getTargetNames();
        this.identificationDescriptors = new IdentificationDescriptor[targetNames.length];
        for (int curTargetNum = 0; curTargetNum < targetNames.length; ++curTargetNum) {
            IdentificationDescriptor identDescriptor;
            this.identificationDescriptors[curTargetNum] = identDescriptor = new IdentificationDescriptor(protocolIdentifier, codeSet, true, association, identifierType, new ScsiNameStringIdentifier(targetNames[curTargetNum]));
        }
    }

    private short getPageLength() {
        short pageLength = 0;
        for (int i = 0; i < this.identificationDescriptors.length; ++i) {
            pageLength = (short)(pageLength + this.identificationDescriptors[i].size());
        }
        return pageLength;
    }

    @Override
    public void serialize(ByteBuffer byteBuffer, int index) {
        byteBuffer.position(index);
        byteBuffer.put((byte)0);
        byteBuffer.put((byte)-125);
        ReadWrite.writeTwoByteInt(byteBuffer, this.getPageLength(), index + 2);
    }

    @Override
    public int size() {
        return this.getPageLength() + 4;
    }
}

