/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.target.scsi.inquiry;

import java.nio.ByteBuffer;
import org.jscsi.target.scsi.ISerializable;
import org.jscsi.target.scsi.inquiry.Association;
import org.jscsi.target.scsi.inquiry.CodeSet;
import org.jscsi.target.scsi.inquiry.Identifier;
import org.jscsi.target.scsi.inquiry.IdentifierType;
import org.jscsi.target.scsi.inquiry.ProtocolIdentifier;
import org.jscsi.target.util.BitManip;

public final class IdentificationDescriptor
implements ISerializable {
    private static final int HEADER_LENGTH = 4;
    private final ProtocolIdentifier protocolIdentifier;
    private final CodeSet codeSet;
    private final boolean protocolIdentifierValid;
    private final Association association;
    private final IdentifierType identifierType;
    private final Identifier identifier;

    public IdentificationDescriptor(ProtocolIdentifier protocolIdentifier, CodeSet codeSet, boolean protocolIdentifierValid, Association association, IdentifierType identifierType, Identifier identifier) {
        this.protocolIdentifier = protocolIdentifier;
        this.codeSet = codeSet;
        this.protocolIdentifierValid = protocolIdentifierValid;
        this.association = association;
        this.identifierType = identifierType;
        this.identifier = identifier;
    }

    @Override
    public void serialize(ByteBuffer byteBuffer, int index) {
        byteBuffer.position(index);
        byte b = (byte)((this.protocolIdentifier.getValue() & 0xF) << 4 | this.codeSet.getValue() & 0xF);
        byteBuffer.put(b);
        b = (byte)((this.association.getValue() & 3) << 4 | this.identifierType.getValue() & 0xF);
        b = BitManip.getByteWithBitSet(b, 7, this.protocolIdentifierValid);
        byteBuffer.put(b);
        byteBuffer.put((byte)0);
        byteBuffer.put((byte)this.identifier.size());
        this.identifier.serialize(byteBuffer, index + 4);
    }

    @Override
    public int size() {
        return this.identifier.size() + 4;
    }
}

