/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.target.scsi.inquiry;

public class PageCode {
    private final int value;

    public PageCode(byte value) {
        this.value = 0xFF & value;
    }

    public final byte getValue() {
        return (byte)this.value;
    }

    public final VitalProductDataPageName getVitalProductDataPageName() {
        if (this.value == 0) {
            return VitalProductDataPageName.SUPPORTED_VPD_PAGES;
        }
        if (1 <= this.value && this.value <= 127) {
            return VitalProductDataPageName.ASCII_INFORMATION;
        }
        if (this.value == 128) {
            return VitalProductDataPageName.UNIT_SERIAL_NUMBER;
        }
        if (this.value == 129 || this.value == 130) {
            return VitalProductDataPageName.OBSOLETE;
        }
        if (this.value == 131) {
            return VitalProductDataPageName.DEVICE_IDENTIFICATION;
        }
        if (this.value == 132) {
            return VitalProductDataPageName.SOFTWARE_INTERFACE_IDENTIFICATION;
        }
        if (this.value == 133) {
            return VitalProductDataPageName.MANAGEMENT_NETWORK_ADDRESSES;
        }
        if (this.value == 134) {
            return VitalProductDataPageName.EXTENDED_INQUIRY_DATA;
        }
        if (this.value == 135) {
            return VitalProductDataPageName.MODE_PAGE_POLICY;
        }
        if (this.value == 136) {
            return VitalProductDataPageName.SCSI_PORTS;
        }
        if (137 <= this.value && this.value <= 175) {
            return VitalProductDataPageName.RESERVED;
        }
        if (176 <= this.value && this.value <= 191) {
            return VitalProductDataPageName.DEVICE_TYPE_SPECIFIC;
        }
        return VitalProductDataPageName.VENDOR_SPECIFIC;
    }

    public String toString() {
        return "0x" + Integer.toHexString(this.value);
    }

    public static enum VitalProductDataPageName {
        SUPPORTED_VPD_PAGES,
        ASCII_INFORMATION,
        UNIT_SERIAL_NUMBER,
        OBSOLETE,
        DEVICE_IDENTIFICATION,
        SOFTWARE_INTERFACE_IDENTIFICATION,
        MANAGEMENT_NETWORK_ADDRESSES,
        EXTENDED_INQUIRY_DATA,
        MODE_PAGE_POLICY,
        SCSI_PORTS,
        RESERVED,
        DEVICE_TYPE_SPECIFIC,
        VENDOR_SPECIFIC;

    }
}

