/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.target.scsi.inquiry;

import java.nio.ByteBuffer;
import org.jscsi.target.scsi.inquiry.Identifier;

public class ScsiNameStringIdentifier
extends Identifier {
    private static final int MAX_SIZE = 256;
    private final String nameString;
    private static final String logicalUnitNameExtension = "493f51ba986f9800";

    public ScsiNameStringIdentifier(String targetName) {
        this.nameString = targetName + ",L,0x" + logicalUnitNameExtension;
    }

    @Override
    public void serialize(ByteBuffer byteBuffer, int index) {
        int i;
        byteBuffer.position(index);
        int size = this.size();
        int stringLength = Math.min(this.nameString.length(), 256);
        if (stringLength == 256) {
            --stringLength;
        }
        for (i = 0; i < stringLength; ++i) {
            byteBuffer.put((byte)this.nameString.charAt(i));
        }
        for (i = 0; i < size - stringLength; ++i) {
            byteBuffer.put((byte)0);
        }
    }

    @Override
    public int size() {
        return Math.min(this.nameString.length() + this.getNullTerminatedPaddingLength(), 256);
    }

    private int getNullTerminatedPaddingLength() {
        return 4 - this.nameString.length() % 4;
    }
}

