/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.target.scsi.inquiry;

import java.nio.ByteBuffer;
import org.jscsi.target.scsi.IResponseData;

public final class StandardInquiryData
implements IResponseData {
    private static final int SIZE = 36;
    private static final String VENDOR_ID = "disyUKon";
    private static final int VENDOR_ID_FIELD_POSITION = 8;
    private static final int VENDOR_ID_FIELD_LENGTH = 8;
    private static final String PRODUCT_ID = "jSCSI Target";
    private static final int PRODUCT_ID_FIELD_POSITION = 16;
    private static final int PRODUCT_ID_FIELD_LENGTH = 16;
    private static final String PRODUCT_REVISION_LEVEL = "1.00";
    private static final int PRODUCT_REVISION_LEVEL_FIELD_POSITION = 32;
    private static final int PRODUCT_REVISION_LEVEL_FIELD_LENGTH = 4;
    private static StandardInquiryData instance;

    private StandardInquiryData() {
    }

    public static StandardInquiryData getInstance() {
        if (instance == null) {
            instance = new StandardInquiryData();
        }
        return instance;
    }

    @Override
    public void serialize(ByteBuffer byteBuffer, int index) {
        byteBuffer.position(index);
        byteBuffer.put((byte)0);
        byteBuffer.put((byte)0);
        byteBuffer.put((byte)5);
        byteBuffer.put((byte)2);
        byteBuffer.put((byte)31);
        byteBuffer.put((byte)0);
        byteBuffer.put((byte)-128);
        byteBuffer.put((byte)0);
        this.putString(byteBuffer, VENDOR_ID, index + 8, 8);
        this.putString(byteBuffer, PRODUCT_ID, index + 16, 16);
        this.putString(byteBuffer, PRODUCT_REVISION_LEVEL, index + 32, 4);
    }

    private void putString(ByteBuffer byteBuffer, String string, int position, int fieldLength) {
        int i;
        byteBuffer.position(position);
        int stringLength = Math.min(string.length(), fieldLength);
        for (i = 0; i < stringLength; ++i) {
            byteBuffer.put((byte)string.charAt(i));
        }
        for (i = stringLength; i < fieldLength; ++i) {
            byteBuffer.put((byte)0);
        }
    }

    @Override
    public int size() {
        return 36;
    }
}

