/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.target.scsi.inquiry;

import java.nio.ByteBuffer;
import org.jscsi.target.scsi.IResponseData;
import org.jscsi.target.scsi.inquiry.PageCode;

public final class SupportedVpdPages
implements IResponseData {
    private static final int HEADER_SIZE = 4;
    private static SupportedVpdPages instance;
    public static final byte[] SUPPORTED_VPD_PAGES;

    public static SupportedVpdPages getInstance() {
        if (instance == null) {
            instance = new SupportedVpdPages();
        }
        return instance;
    }

    private SupportedVpdPages() {
    }

    @Override
    public void serialize(ByteBuffer byteBuffer, int index) {
        byteBuffer.position(index);
        byteBuffer.put((byte)0);
        byteBuffer.put((byte)0);
        byteBuffer.put((byte)0);
        byteBuffer.put((byte)SUPPORTED_VPD_PAGES.length);
        for (int i = 0; i < SUPPORTED_VPD_PAGES.length; ++i) {
            byteBuffer.put(SUPPORTED_VPD_PAGES[i]);
        }
    }

    @Override
    public int size() {
        return 4 + SUPPORTED_VPD_PAGES.length;
    }

    public static boolean vpdPageCodeSupported(PageCode.VitalProductDataPageName vitalProductDataPageName) {
        for (int i = 0; i < SUPPORTED_VPD_PAGES.length; ++i) {
            PageCode pageCode = new PageCode(SUPPORTED_VPD_PAGES[i]);
            if (pageCode.getVitalProductDataPageName() != vitalProductDataPageName) continue;
            return true;
        }
        return false;
    }

    static {
        SUPPORTED_VPD_PAGES = new byte[]{0, -125};
    }
}

