/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.target.scsi.lun;

import java.nio.ByteBuffer;
import org.jscsi.target.scsi.IResponseData;
import org.jscsi.target.scsi.lun.LogicalUnitNumber;
import org.jscsi.target.util.ReadWrite;

public final class ReportLunsParameterData
implements IResponseData {
    private static final int HEADER_LENGTH = 8;
    private int lunListLength = 0;
    private LogicalUnitNumber[] luns;

    public ReportLunsParameterData(LogicalUnitNumber ... luns) {
        this.luns = luns;
        if (luns != null) {
            this.lunListLength = 8 * luns.length;
        }
    }

    @Override
    public void serialize(ByteBuffer byteBuffer, int index) {
        ReadWrite.writeInt(this.lunListLength, byteBuffer, index);
        int lunIndex = index + 8;
        for (int i = 0; i < this.luns.length; ++i) {
            this.luns[i].serialize(byteBuffer, lunIndex);
            lunIndex += this.luns[i].size();
        }
    }

    @Override
    public int size() {
        return 8 + this.lunListLength;
    }
}

