/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.target.scsi.modeSense;

import java.nio.ByteBuffer;
import org.jscsi.target.scsi.ISerializable;
import org.jscsi.target.util.BitManip;

public abstract class ModePage
implements ISerializable {
    private static final int SUB_PAGE_FORMAT_PAGE_LENGTH_MODIFIER = 4;
    private static final int PAGE_0_FORMAT_PAGE_LENGTH_MODIFIER = 2;
    private final boolean parametersSaveable;
    private final boolean subPageFormat;
    private final int pageCode;
    protected final int pageLength;
    private final int pageLengthModifier;

    public ModePage(boolean parametersSaveable, boolean subPageFormat, int pageCode, int pageLength) {
        this.parametersSaveable = parametersSaveable;
        this.subPageFormat = subPageFormat;
        this.pageLengthModifier = subPageFormat ? 4 : 2;
        this.pageCode = pageCode;
        this.pageLength = pageLength;
    }

    @Override
    public final void serialize(ByteBuffer byteBuffer, int index) {
        byte b = (byte)this.pageCode;
        b = BitManip.getByteWithBitSet(b, 6, this.subPageFormat);
        b = BitManip.getByteWithBitSet(b, 7, this.parametersSaveable);
        byteBuffer.position(index);
        byteBuffer.put(b);
        this.serializeSubPageCode(byteBuffer, index);
        this.serializePageLength(byteBuffer, index);
        this.serializeModeParameters(byteBuffer, index);
    }

    protected abstract void serializeSubPageCode(ByteBuffer var1, int var2);

    protected abstract void serializePageLength(ByteBuffer var1, int var2);

    protected abstract void serializeModeParameters(ByteBuffer var1, int var2);

    @Override
    public final int size() {
        return this.pageLength + this.pageLengthModifier;
    }
}

