/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.target.scsi.modeSense;

import java.nio.ByteBuffer;
import org.jscsi.target.scsi.IResponseData;
import org.jscsi.target.scsi.ISerializable;
import org.jscsi.target.scsi.modeSense.HeaderType;
import org.jscsi.target.scsi.modeSense.LogicalBlockDescriptor;
import org.jscsi.target.scsi.modeSense.ModePage;
import org.jscsi.target.scsi.modeSense.ModeParameterHeader;
import org.jscsi.target.scsi.modeSense.ModeParameterHeader10;
import org.jscsi.target.scsi.modeSense.ModeParameterHeader6;
import org.jscsi.target.scsi.modeSense.ModeParameterListBuilder;

public final class ModeParameterList
implements IResponseData {
    private final ModeParameterHeader modeParameterHeader;
    private final LogicalBlockDescriptor[] logicalBlockDescriptors;
    private final ModePage[] modePages;

    public static ModeParameterList build(ModeParameterListBuilder builder) {
        int blockDescriptorLength;
        if (!builder.checkIntegrity()) {
            return null;
        }
        if (builder.logicalBlockDescriptors == null) {
            blockDescriptorLength = 0;
        } else {
            int singleLbdLength = builder.longLba ? 16 : 8;
            blockDescriptorLength = builder.logicalBlockDescriptors.length * singleLbdLength;
        }
        int modeDataLength = builder.headerType == HeaderType.MODE_PARAMETER_HEADER_6 ? 3 : 6;
        modeDataLength += blockDescriptorLength;
        if (builder.modePages != null) {
            for (ModePage mp : builder.modePages) {
                modeDataLength += mp.size();
            }
        }
        ModeParameterHeader modeParameterHeader = builder.headerType == HeaderType.MODE_PARAMETER_HEADER_6 ? new ModeParameterHeader6(modeDataLength, blockDescriptorLength) : new ModeParameterHeader10(modeDataLength, blockDescriptorLength, builder.longLba);
        return new ModeParameterList(modeParameterHeader, builder.logicalBlockDescriptors, builder.modePages);
    }

    private ModeParameterList(ModeParameterHeader modeParameterHeader, LogicalBlockDescriptor[] logicalBlockDescriptors, ModePage[] modePages) {
        this.modeParameterHeader = modeParameterHeader;
        this.logicalBlockDescriptors = logicalBlockDescriptors;
        this.modePages = modePages;
    }

    @Override
    public void serialize(ByteBuffer byteBuffer, int index) {
        int offset = 0;
        this.modeParameterHeader.serialize(byteBuffer, index);
        offset += this.modeParameterHeader.size();
        if (this.logicalBlockDescriptors != null) {
            for (ISerializable iSerializable : this.logicalBlockDescriptors) {
                iSerializable.serialize(byteBuffer, index + offset);
                offset += iSerializable.size();
            }
        }
        if (this.modePages != null) {
            for (ISerializable iSerializable : this.modePages) {
                ((ModePage)iSerializable).serialize(byteBuffer, index + offset);
                offset += ((ModePage)iSerializable).size();
            }
        }
    }

    @Override
    public int size() {
        int size = this.modeParameterHeader.size();
        if (this.logicalBlockDescriptors != null && this.logicalBlockDescriptors.length > 0) {
            size += this.logicalBlockDescriptors[0].size() * this.logicalBlockDescriptors.length;
        }
        if (this.modePages != null) {
            for (ModePage mp : this.modePages) {
                size += mp.size();
            }
        }
        return size;
    }
}

