/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.target.scsi.readCapacity;

import java.nio.ByteBuffer;
import org.jscsi.target.scsi.readCapacity.ReadCapacityParameterData;
import org.jscsi.target.util.ReadWrite;

public final class ReadCapacity10ParameterData
extends ReadCapacityParameterData {
    private static final long MAX_RETURNED_LOGICAL_BLOCK_ADDRESS = 0xFFFFFFFFL;
    private static final int SIZE = 8;

    public ReadCapacity10ParameterData(long returnedLogicalBlockAddress, int logicalBlockLengthInBytes) {
        super(returnedLogicalBlockAddress, logicalBlockLengthInBytes);
    }

    @Override
    public void serialize(ByteBuffer byteBuffer, int index) {
        int rlba = (int)Math.min(this.returnedLogicalBlockAddress, 0xFFFFFFFFL);
        ReadWrite.writeInt(rlba, byteBuffer, index);
        ReadWrite.writeInt(this.logicalBlockLengthInBytes, byteBuffer, index + 4);
    }

    @Override
    public int size() {
        return 8;
    }
}

