/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.target.scsi.sense;

import java.nio.ByteBuffer;
import org.jscsi.target.scsi.sense.AdditionalSenseCodeAndQualifier;
import org.jscsi.target.scsi.sense.ErrorType;
import org.jscsi.target.scsi.sense.SenseData;
import org.jscsi.target.scsi.sense.SenseDataFormat;
import org.jscsi.target.scsi.sense.SenseKey;
import org.jscsi.target.scsi.sense.senseDataDescriptor.SenseDataDescriptor;
import org.jscsi.target.util.BitManip;
import org.jscsi.target.util.ReadWrite;

public final class DescriptorFormatSenseData
extends SenseData {
    private static final int HEADER_LENGTH = 8;
    private static final int ADDITIONAL_SENSE_CODE_INDEX = 2;
    private static final int RESERVED_BYTES_MIN_INDEX = 4;
    private static final int RESERVED_BYTES_MAX_INDEX = 6;
    private static final int ADDITIONAL_SENSE_LENGTH_INDEX = 7;
    private final SenseDataDescriptor[] senseDataDescriptors;

    public DescriptorFormatSenseData(ErrorType errorType, SenseKey senseKey, AdditionalSenseCodeAndQualifier additionalSenseCodeAndQualifier, SenseDataDescriptor ... senseDataDescriptors) {
        super(errorType, SenseDataFormat.DESCRIPTOR, senseKey, additionalSenseCodeAndQualifier);
        this.senseDataDescriptors = senseDataDescriptors;
    }

    @Override
    public void serialize(ByteBuffer byteBuffer, int index) {
        byteBuffer.position(index);
        byte b = (byte)DescriptorFormatSenseData.getReponseCodeFor(this.errorType, SenseDataFormat.DESCRIPTOR);
        b = BitManip.getByteWithBitSet(b, 7, false);
        byteBuffer.put(b);
        b = (byte)(this.senseKey.getValue() & 0xF);
        byteBuffer.put(b);
        ReadWrite.writeTwoByteInt(byteBuffer, this.additionalSenseCodeAndQualifier.getValue(), index + 2);
        for (int i = index + 4; i < index + 6; ++i) {
            byteBuffer.put(i, (byte)0);
        }
        byteBuffer.put(index + 7, (byte)this.getAdditionalSenseLength());
        int descriptorIndex = 8;
        for (int i = 0; i < this.senseDataDescriptors.length; ++i) {
            if (this.senseDataDescriptors[i] == null) continue;
            this.senseDataDescriptors[i].serialize(byteBuffer, descriptorIndex);
            descriptorIndex += this.senseDataDescriptors[i].size();
        }
    }

    private int getAdditionalSenseLength() {
        int additionalSenseLength = 0;
        if (this.senseDataDescriptors != null) {
            for (int i = 0; i < this.senseDataDescriptors.length; ++i) {
                if (this.senseDataDescriptors[i] == null) continue;
                additionalSenseLength += this.senseDataDescriptors[i].size();
            }
        }
        return additionalSenseLength;
    }

    @Override
    public int size() {
        return this.getAdditionalSenseLength() + 8;
    }
}

