/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.target.scsi.sense;

import java.nio.ByteBuffer;
import org.jscsi.target.scsi.sense.AdditionalSenseBytes;
import org.jscsi.target.scsi.sense.AdditionalSenseCodeAndQualifier;
import org.jscsi.target.scsi.sense.ErrorType;
import org.jscsi.target.scsi.sense.SenseData;
import org.jscsi.target.scsi.sense.SenseDataFormat;
import org.jscsi.target.scsi.sense.SenseKey;
import org.jscsi.target.scsi.sense.information.FourByteInformation;
import org.jscsi.target.scsi.sense.senseDataDescriptor.senseKeySpecific.SenseKeySpecificData;
import org.jscsi.target.util.BitManip;
import org.jscsi.target.util.ReadWrite;

public class FixedFormatSenseData
extends SenseData {
    private static final int INFORMATION_FIELD_INDEX = 3;
    private static final int ADDITIONAL_SENSE_LENGTH_INDEX = 7;
    private static final int COMMAND_SPECIFIC_INFORMATION_FIELD_INDEX = 8;
    private static final int ADDITIONAL_SENSE_CODE_INDEX = 12;
    private static final int FIELD_REPLACEABLE_UNIT_CODE_INDEX = 14;
    private static final int SENSE_KEY_SPECIFIC_DATA_INDEX = 15;
    private static final int MIN_SIZE = 18;
    private static final int MIN_ADDITIONAL_SENSE_LENGTH = 10;
    private final boolean valid;
    private final boolean fileMark;
    private final boolean endOfMedium;
    private final boolean incorrectLengthIndicator;
    private final FourByteInformation information;
    private final FourByteInformation commandSpecificInformation;
    private final byte fieldReplaceableUnitCode;
    private final SenseKeySpecificData senseKeySpecificData;
    private final AdditionalSenseBytes additionalSenseBytes;
    private final int additionalSenseLength;

    public FixedFormatSenseData(boolean valid, ErrorType errorType, boolean fileMark, boolean endOfMedium, boolean incorrectLengthIndicator, SenseKey senseKey, FourByteInformation information, FourByteInformation commandSpecificInformation, AdditionalSenseCodeAndQualifier additionalSenseCodeAndQualifier, byte fieldReplaceableUnitCode, SenseKeySpecificData senseKeySpecificData, AdditionalSenseBytes additionalSenseBytes) {
        super(errorType, SenseDataFormat.FIXED, senseKey, additionalSenseCodeAndQualifier);
        this.valid = valid;
        this.fileMark = fileMark;
        this.endOfMedium = endOfMedium;
        this.incorrectLengthIndicator = incorrectLengthIndicator;
        this.information = information;
        this.commandSpecificInformation = commandSpecificInformation;
        this.fieldReplaceableUnitCode = fieldReplaceableUnitCode;
        this.senseKeySpecificData = senseKeySpecificData;
        this.additionalSenseBytes = additionalSenseBytes;
        int asl = 10;
        if (additionalSenseBytes != null) {
            asl += additionalSenseBytes.size();
        }
        this.additionalSenseLength = asl;
    }

    @Override
    public void serialize(ByteBuffer byteBuffer, int index) {
        byteBuffer.position(index);
        byte b = (byte)FixedFormatSenseData.getReponseCodeFor(this.errorType, SenseDataFormat.FIXED);
        b = BitManip.getByteWithBitSet(b, 7, this.valid);
        byteBuffer.put(b);
        byteBuffer.put((byte)0);
        b = BitManip.getByteWithBitSet((byte)0, 7, this.fileMark);
        b = BitManip.getByteWithBitSet(b, 6, this.endOfMedium);
        b = BitManip.getByteWithBitSet(b, 5, this.incorrectLengthIndicator);
        b = (byte)(0xF & this.senseKey.getValue());
        byteBuffer.put(b);
        if (this.information != null) {
            this.information.serialize(byteBuffer, index + 3);
        }
        byteBuffer.put(index + 7, (byte)this.additionalSenseLength);
        if (this.commandSpecificInformation != null) {
            this.commandSpecificInformation.serialize(byteBuffer, index + 8);
        }
        ReadWrite.writeTwoByteInt(byteBuffer, this.additionalSenseCodeAndQualifier.getValue(), index + 12);
        byteBuffer.put(14, this.fieldReplaceableUnitCode);
        if (this.senseKeySpecificData != null) {
            this.senseKeySpecificData.serialize(byteBuffer, index + 15);
        }
        if (this.additionalSenseBytes != null) {
            this.additionalSenseBytes.serialize(byteBuffer, index + 18);
        }
    }

    public final int getAdditionalSenseLength() {
        return this.additionalSenseLength;
    }

    @Override
    public int size() {
        int size = 18;
        if (this.additionalSenseBytes != null) {
            size += this.additionalSenseBytes.size();
        }
        return size;
    }
}

