/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.target.scsi.sense;

import org.jscsi.target.scsi.ISerializable;
import org.jscsi.target.scsi.sense.AdditionalSenseCodeAndQualifier;
import org.jscsi.target.scsi.sense.ErrorType;
import org.jscsi.target.scsi.sense.SenseDataFormat;
import org.jscsi.target.scsi.sense.SenseKey;

public abstract class SenseData
implements ISerializable {
    protected final int responseCode;
    protected final ErrorType errorType;
    protected final SenseDataFormat senseDataFormat;
    protected final SenseKey senseKey;
    protected final AdditionalSenseCodeAndQualifier additionalSenseCodeAndQualifier;

    public SenseData(ErrorType errorType, SenseDataFormat senseDataFormat, SenseKey senseKey, AdditionalSenseCodeAndQualifier additionalSenseCodeAndQualifier) {
        this.errorType = errorType;
        this.senseDataFormat = senseDataFormat;
        this.responseCode = SenseData.getReponseCodeFor(errorType, senseDataFormat);
        this.senseKey = senseKey;
        this.additionalSenseCodeAndQualifier = additionalSenseCodeAndQualifier;
    }

    public static final int getReponseCodeFor(ErrorType errorType, SenseDataFormat senseDataFormat) {
        if (senseDataFormat == SenseDataFormat.FIXED) {
            if (errorType == ErrorType.CURRENT) {
                return 112;
            }
            return 113;
        }
        if (errorType == ErrorType.CURRENT) {
            return 114;
        }
        return 115;
    }
}

