/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.target.scsi.sense.senseDataDescriptor;

import java.nio.ByteBuffer;
import org.jscsi.target.scsi.ISerializable;
import org.jscsi.target.scsi.sense.senseDataDescriptor.SenseDataDescriptorType;

public abstract class SenseDataDescriptor
implements ISerializable {
    private static final int COMMON_FIELDS_LENGTH = 2;
    private final SenseDataDescriptorType descriptorType;
    private final int additionalLength;

    public SenseDataDescriptor(SenseDataDescriptorType descriptorType, int additionalLength) {
        this.descriptorType = descriptorType;
        this.additionalLength = additionalLength;
    }

    private final void serializeCommonFields(ByteBuffer byteBuffer, int index) {
        byteBuffer.position(index);
        byteBuffer.put(this.descriptorType.getValue());
        byteBuffer.put((byte)this.additionalLength);
    }

    protected abstract void serializeSpecificFields(ByteBuffer var1, int var2);

    private final int getAdditionalLength() {
        return this.additionalLength;
    }

    @Override
    public void serialize(ByteBuffer byteBuffer, int index) {
        this.serializeCommonFields(byteBuffer, index);
        this.serializeSpecificFields(byteBuffer, index);
    }

    @Override
    public int size() {
        return 2 + this.getAdditionalLength();
    }
}

