/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.target.settings;

import java.util.List;
import java.util.Vector;
import org.jscsi.parser.login.LoginStage;
import org.jscsi.target.TargetServer;
import org.jscsi.target.settings.BooleanResultFunction;
import org.jscsi.target.settings.ConnectionSettingsBuilderComponent;
import org.jscsi.target.settings.KeySet;
import org.jscsi.target.settings.NegotiationStatus;
import org.jscsi.target.settings.NegotiationType;
import org.jscsi.target.settings.NumericalResultFunction;
import org.jscsi.target.settings.NumericalValueRange;
import org.jscsi.target.settings.SessionSettingsNegotiator;
import org.jscsi.target.settings.Settings;
import org.jscsi.target.settings.SettingsNegotiator;
import org.jscsi.target.settings.TextParameter;
import org.jscsi.target.settings.entry.BooleanEntry;
import org.jscsi.target.settings.entry.Entry;
import org.jscsi.target.settings.entry.NumericalEntry;
import org.jscsi.target.settings.entry.NumericalRangeEntry;
import org.jscsi.target.settings.entry.StringEntry;
import org.jscsi.target.settings.entry.Use;

public final class ConnectionSettingsNegotiator
extends SettingsNegotiator {
    private final SessionSettingsNegotiator sessionSettingsNegotiator;
    private ConnectionSettingsBuilderComponent connectionSettingBuilderComponent;
    private Settings settings;

    public ConnectionSettingsNegotiator(SessionSettingsNegotiator sessionSettingsNegotiator) {
        this.sessionSettingsNegotiator = sessionSettingsNegotiator;
        this.updateSettingsBuilderComponent();
        this.updateSettings();
    }

    public boolean beginNegotiation() {
        boolean hasLock = this.sessionSettingsNegotiator.lock();
        if (hasLock) {
            this.backUpEntries();
            this.sessionSettingsNegotiator.backUpEntries();
        }
        return hasLock;
    }

    public void finishNegotiation(boolean commitChanges) {
        this.commitOrRollBackChanges(commitChanges);
        this.sessionSettingsNegotiator.commitOrRollBackChanges(commitChanges);
        this.updateSettingsBuilderComponent();
        this.sessionSettingsNegotiator.updateSettingsBuilderComponent();
        this.updateSettings();
        this.sessionSettingsNegotiator.unlock();
    }

    public boolean negotiate(TargetServer target, LoginStage loginStage, boolean leadingConnection, boolean initialPdu, List<String> requestKeyValuePairs, List<String> responseKeyValuePairs) {
        Vector<String> keys = new Vector<String>();
        Vector<String> values = new Vector<String>();
        for (String keyValuePair : requestKeyValuePairs) {
            String[] split = TextParameter.splitKeyValuePair(keyValuePair);
            if (split == null) {
                System.err.println("malformatted key=value pair: " + keyValuePair);
                return false;
            }
            keys.add(split[0]);
            values.add(split[1]);
        }
        boolean everythingOkay = true;
        while (keys.size() > 0) {
            Entry entry = this.getEntry((String)keys.get(0));
            if (entry == null) {
                responseKeyValuePairs.add(TextParameter.toKeyValuePair((String)keys.get(0), "NotUnderstood"));
            } else {
                everythingOkay &= entry.negotiate(target, loginStage, leadingConnection, initialPdu, (String)keys.get(0), (String)values.get(0), responseKeyValuePairs);
            }
            keys.remove(0);
            values.remove(0);
        }
        if (initialPdu) {
            everythingOkay &= this.getEntry("InitiatorName").checkAccepted();
            boolean normalSession = "Normal".equals(((StringEntry)this.getEntry("SessionType")).getStringValue());
            if (normalSession) {
                StringEntry targetNameEntry = (StringEntry)this.getEntry("TargetName");
                String targetName = targetNameEntry.getStringValue();
                if (targetName == null || !target.isValidTargetName(targetName)) {
                    everythingOkay = false;
                }
                String targetAlias = null;
                if (everythingOkay) {
                    targetAlias = target.getTarget(targetName).getTargetAlias();
                }
                if (targetAlias != null) {
                    responseKeyValuePairs.add(TextParameter.toKeyValuePair("TargetAlias", targetAlias));
                }
                responseKeyValuePairs.add(TextParameter.toKeyValuePair("TargetPortalGroupTag", Integer.valueOf(target.getConfig().getTargetPortalGroupTag()).toString()));
            }
        }
        return everythingOkay;
    }

    @Override
    public boolean checkConstraints() {
        return this.sessionSettingsNegotiator.checkConstraints();
    }

    private Entry getEntry(String key) {
        Entry entry = ConnectionSettingsNegotiator.getEntry(key, this.entries);
        if (entry == null) {
            entry = this.sessionSettingsNegotiator.getEntry(key);
        }
        return entry;
    }

    public Settings getSettings() {
        if (this.sessionSettingsNegotiator.getCurrentSettingsId() > this.settings.getSettingsId()) {
            this.updateSettings();
        }
        return this.settings;
    }

    private synchronized void updateSettings() {
        this.settings = new Settings(this.connectionSettingBuilderComponent, this.sessionSettingsNegotiator.getSessionSettingsBuilderComponent());
    }

    @Override
    protected void initializeEntries() {
        this.entries.add(new StringEntry(new KeySet("DataDigest"), NegotiationType.NEGOTIATED, Use.LOPNS, NegotiationStatus.DEFAULT, new String[]{"None"}, "None"));
        this.entries.add(new StringEntry(new KeySet("HeaderDigest"), NegotiationType.NEGOTIATED, Use.LOPNS, NegotiationStatus.DEFAULT, new String[]{"None"}, "None"));
        this.entries.add(new BooleanEntry(new KeySet("IFMarker"), Use.LOPNS, NegotiationStatus.DEFAULT, false, BooleanResultFunction.AND, false));
        this.entries.add(new NumericalRangeEntry(new KeySet("IFMarkInt"), Use.LOPNS, NegotiationStatus.IRRELEVANT, 2048, NumericalValueRange.create(1, 65535), 2048));
        this.entries.add(new NumericalEntry(new KeySet("MaxRecvDataSegmentLength"), NegotiationType.DECLARED, Use.LOPNS_AND_FFP, NegotiationStatus.DEFAULT, 8192, NumericalValueRange.create(512, 0xFFFFFF), NumericalResultFunction.MIN, 8192, true));
        this.entries.add(new BooleanEntry(new KeySet("OFMarker"), Use.LOPNS, NegotiationStatus.DEFAULT, false, BooleanResultFunction.AND, false));
        this.entries.add(new NumericalRangeEntry(new KeySet("OFMarkInt"), Use.LOPNS, NegotiationStatus.IRRELEVANT, 2048, NumericalValueRange.create(1, 65535), 2048));
        this.entries.add(new StringEntry(new KeySet("TargetName"), NegotiationType.DECLARED, Use.INITIAL, NegotiationStatus.NOT_NEGOTIATED, null, null));
    }

    protected void updateSettingsBuilderComponent() {
        this.connectionSettingBuilderComponent = new ConnectionSettingsBuilderComponent(this.entries);
    }
}

