/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.target.settings;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jscsi.target.settings.NumericalValueRange;
import org.jscsi.target.settings.SingleNumericalValue;

public abstract class NumericalValue {
    private static final String DECIMAL_REGEX = "0|[-]?[1-9][0-9]*";
    private static final String HEX_REGEX = "0[x|X][0-9a-fA-F]+";
    private static final String BASE_64_REGEX = "0[b|B][0-9a-zA-Z+/]+";
    private static final String SINGLE_CONSTANT_REGEX = "0|[-]?[1-9][0-9]*|0[x|X][0-9a-fA-F]+|0[b|B][0-9a-zA-Z+/]+";
    public static final Pattern DECIMAL_CONSTANT_PATTERN = Pattern.compile("0|[-]?[1-9][0-9]*");
    public static final Pattern HEX_CONSTANT_PATTERN = Pattern.compile("0[x|X][0-9a-fA-F]+");
    public static final Pattern BASE_64_CONSTANT_PATTERN = Pattern.compile("0[b|B][0-9a-zA-Z+/]+");
    public static final Pattern SINGLE_CONSTANT_PATTERN = Pattern.compile("0|[-]?[1-9][0-9]*|0[x|X][0-9a-fA-F]+|0[b|B][0-9a-zA-Z+/]+");
    public static final Pattern NUMERICAL_RANGE_PATTERN = Pattern.compile("(0|[-]?[1-9][0-9]*|0[x|X][0-9a-fA-F]+|0[b|B][0-9a-zA-Z+/]+)~(0|[-]?[1-9][0-9]*|0[x|X][0-9a-fA-F]+|0[b|B][0-9a-zA-Z+/]+)");

    public static final NumericalValue parseNumericalValue(String value) {
        Matcher singleValueMatcher = SINGLE_CONSTANT_PATTERN.matcher(value);
        if (singleValueMatcher.matches()) {
            return SingleNumericalValue.parseSingleNumericValue(value);
        }
        Matcher rangeMatcher = NUMERICAL_RANGE_PATTERN.matcher(value);
        if (rangeMatcher.matches()) {
            return NumericalValueRange.parseNumericalValueRange(value);
        }
        return null;
    }

    public NumericalValue intersect(NumericalValue value) {
        return NumericalValue.intersect(this, value);
    }

    public static NumericalValue intersect(NumericalValue a, NumericalValue b) {
        int bMax;
        int bMin;
        NumericalValueRange r;
        int aMax;
        int aMin;
        SingleNumericalValue v;
        if (a == null || b == null) {
            return null;
        }
        if (a instanceof SingleNumericalValue) {
            v = (SingleNumericalValue)a;
            aMax = aMin = v.getValue();
        } else {
            r = (NumericalValueRange)a;
            aMin = r.getMin();
            aMax = r.getMax();
        }
        if (b instanceof SingleNumericalValue) {
            v = (SingleNumericalValue)b;
            bMax = bMin = v.getValue();
        } else {
            r = (NumericalValueRange)b;
            bMin = r.getMin();
            bMax = r.getMax();
        }
        int min = Math.max(aMin, bMin);
        int max = Math.min(aMax, bMax);
        if (min == max) {
            return SingleNumericalValue.create(min);
        }
        return NumericalValueRange.create(min, max);
    }

    public abstract boolean contains(Object var1);

    public abstract boolean contains(int var1);
}

