/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.target.settings;

import java.util.regex.Matcher;
import org.jscsi.target.settings.NumericalValue;
import org.jscsi.target.settings.SingleNumericalValue;

public final class NumericalValueRange
extends NumericalValue {
    private final int min;
    private final int max;

    public static final NumericalValueRange create(int min, int max) {
        if (min > max) {
            return null;
        }
        return new NumericalValueRange(min, max);
    }

    public static final NumericalValueRange parseNumericalValueRange(String value) {
        Matcher rangeMatcher = NUMERICAL_RANGE_PATTERN.matcher(value);
        if (!rangeMatcher.matches()) {
            return null;
        }
        String[] numbers = value.split("~");
        SingleNumericalValue minVal = SingleNumericalValue.parseSingleNumericValue(numbers[0]);
        SingleNumericalValue maxVal = SingleNumericalValue.parseSingleNumericValue(numbers[1]);
        if (minVal == null || maxVal == null) {
            return null;
        }
        int min = minVal.getValue();
        int max = maxVal.getValue();
        return NumericalValueRange.create(min, max);
    }

    private NumericalValueRange(int min, int max) {
        if (min <= max) {
            this.min = min;
            this.max = max;
        } else {
            this.min = max;
            this.max = min;
        }
    }

    public final int getMin() {
        return this.min;
    }

    public final int getMax() {
        return this.max;
    }

    public final String toString() {
        return "[" + this.min + "," + this.max + "]";
    }

    @Override
    public boolean contains(Object value) {
        if (value instanceof NumericalValue) {
            return this.contains((NumericalValue)value);
        }
        if (value instanceof Integer) {
            return this.contains((Integer)value);
        }
        return false;
    }

    public boolean contains(NumericalValue value) {
        if (value instanceof SingleNumericalValue) {
            return this.contains((SingleNumericalValue)value);
        }
        if (value instanceof NumericalValueRange) {
            return this.contains((NumericalValueRange)value);
        }
        return false;
    }

    public boolean contains(NumericalValueRange range) {
        if (range == null) {
            return false;
        }
        return this.min <= range.getMin() && range.getMax() <= this.max;
    }

    public boolean contains(SingleNumericalValue value) {
        if (value == null) {
            return false;
        }
        return this.contains(value.getValue());
    }

    @Override
    public boolean contains(int value) {
        return this.min <= value && value <= this.max;
    }
}

