/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.target.settings;

import java.util.concurrent.atomic.AtomicLong;
import javax.naming.OperationNotSupportedException;
import org.jscsi.target.settings.BooleanResultFunction;
import org.jscsi.target.settings.KeySet;
import org.jscsi.target.settings.NegotiationStatus;
import org.jscsi.target.settings.NegotiationType;
import org.jscsi.target.settings.NumericalResultFunction;
import org.jscsi.target.settings.NumericalValueRange;
import org.jscsi.target.settings.SessionSettingsBuilderComponent;
import org.jscsi.target.settings.SettingsNegotiator;
import org.jscsi.target.settings.entry.BooleanEntry;
import org.jscsi.target.settings.entry.Entry;
import org.jscsi.target.settings.entry.NumericalEntry;
import org.jscsi.target.settings.entry.StringEntry;
import org.jscsi.target.settings.entry.Use;
import org.jscsi.target.util.BinaryLock;

public final class SessionSettingsNegotiator
extends SettingsNegotiator {
    private final BinaryLock lock = new BinaryLock();
    private final AtomicLong currentSettingsId = new AtomicLong();
    private SessionSettingsBuilderComponent sessionSettingBuilderComponent;

    public SessionSettingsNegotiator() {
        this.updateSettingsBuilderComponent();
    }

    boolean lock() {
        return this.lock.lock();
    }

    void unlock() {
        this.lock.unlock();
    }

    Entry getEntry(String key) {
        return SessionSettingsNegotiator.getEntry(key, this.entries);
    }

    long getCurrentSettingsId() {
        return this.currentSettingsId.get();
    }

    @Override
    protected void initializeEntries() {
        this.entries.add(new BooleanEntry(new KeySet("DataPDUInOrder"), Use.LEADING_LOPNS, NegotiationStatus.DEFAULT, true, BooleanResultFunction.OR, true));
        this.entries.add(new BooleanEntry(new KeySet("DataSequenceInOrder"), Use.LEADING_LOPNS, NegotiationStatus.DEFAULT, true, BooleanResultFunction.OR, true));
        this.entries.add(new NumericalEntry(new KeySet("DefaultTime2Retain", "Time2Retain"), NegotiationType.NEGOTIATED, Use.LEADING_LOPNS, NegotiationStatus.DEFAULT, 0, NumericalValueRange.create(0, 3600), NumericalResultFunction.MIN, 20, false));
        this.entries.add(new NumericalEntry(new KeySet("DefaultTime2Wait", "Time2Wait"), NegotiationType.NEGOTIATED, Use.LEADING_LOPNS, NegotiationStatus.DEFAULT, 2, NumericalValueRange.create(0, 3600), NumericalResultFunction.MAX, 2, false));
        this.entries.add(new NumericalEntry(new KeySet("ErrorRecoveryLevel"), NegotiationType.NEGOTIATED, Use.LEADING_LOPNS, NegotiationStatus.DEFAULT, 0, NumericalValueRange.create(0, 2), NumericalResultFunction.MIN, 0, false));
        this.entries.add(new NumericalEntry(new KeySet("FirstBurstLength"), NegotiationType.NEGOTIATED, Use.LEADING_LOPNS, NegotiationStatus.DEFAULT, 65536, NumericalValueRange.create(512, 0xFFFFFF), NumericalResultFunction.MIN, 65536, true));
        this.entries.add(new BooleanEntry(new KeySet("ImmediateData"), Use.LEADING_LOPNS, NegotiationStatus.DEFAULT, true, BooleanResultFunction.AND, true));
        this.entries.add(new BooleanEntry(new KeySet("InitialR2T"), Use.LEADING_LOPNS, NegotiationStatus.DEFAULT, true, BooleanResultFunction.OR, true));
        this.entries.add(new StringEntry(new KeySet("InitiatorAlias"), NegotiationType.DECLARED, Use.INITIAL_AND_FFP, NegotiationStatus.NOT_NEGOTIATED, null, null));
        this.entries.add(new StringEntry(new KeySet("InitiatorName"), NegotiationType.DECLARED, Use.INITIAL, NegotiationStatus.NOT_NEGOTIATED, null, null));
        this.entries.add(new NumericalEntry(new KeySet("MaxBurstLength"), NegotiationType.NEGOTIATED, Use.LEADING_LOPNS, NegotiationStatus.DEFAULT, 262144, NumericalValueRange.create(512, 0xFFFFFF), NumericalResultFunction.MIN, 262144, true));
        this.entries.add(new NumericalEntry(new KeySet("MaxConnections"), NegotiationType.NEGOTIATED, Use.LEADING_LOPNS, NegotiationStatus.DEFAULT, 1, NumericalValueRange.create(1, 65535), NumericalResultFunction.MIN, 1, false));
        this.entries.add(new NumericalEntry(new KeySet("MaxOutstandingR2T"), NegotiationType.NEGOTIATED, Use.LEADING_LOPNS, NegotiationStatus.DEFAULT, 1, NumericalValueRange.create(1, 65535), NumericalResultFunction.MIN, 1, false));
        this.entries.add(new StringEntry(new KeySet("SessionType"), NegotiationType.DECLARED, Use.INITIAL, NegotiationStatus.DEFAULT, null, "Normal"));
    }

    protected void updateSettingsBuilderComponent() {
        this.sessionSettingBuilderComponent = new SessionSettingsBuilderComponent(this.currentSettingsId.getAndIncrement() + 1L, this.entries);
    }

    SessionSettingsBuilderComponent getSessionSettingsBuilderComponent() {
        return this.sessionSettingBuilderComponent;
    }

    @Override
    public boolean checkConstraints() {
        try {
            int firstBurstLength = this.getEntry("FirstBurstLength").getIntegerValue();
            int maxBurstLength = this.getEntry("MaxBurstLength").getIntegerValue();
            if (maxBurstLength > firstBurstLength) {
                return false;
            }
        }
        catch (OperationNotSupportedException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

