/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.target.settings;

import org.jscsi.target.settings.ConnectionSettingsBuilderComponent;
import org.jscsi.target.settings.SessionSettingsBuilderComponent;
import org.jscsi.target.settings.SettingsException;

public final class Settings {
    private final long settingsId;
    private final String dataDigest;
    private final String headerDigest;
    private final Boolean ifMarker;
    private final Integer ifMarkInt;
    private final Integer maxRecvDataSegmentLength;
    private final Boolean ofMarker;
    private final Integer ofMarkInt;
    private final String targetName;
    private final Boolean dataPduInOrder;
    private final Boolean dataSequenceInOrder;
    private final Integer defaultTime2Retain;
    private final Integer defaultTime2Wait;
    private final Integer errorRecoveryLevel;
    private final Integer firstBurstLength;
    private final Boolean immediateData;
    private final Boolean initialR2T;
    private final String initiatorAlias;
    private final String initiatorName;
    private final Integer maxBurstLength;
    private final Integer maxConnections;
    private final Integer maxOutstandingR2T;
    private final String sessionType;

    private static void checkIfNull(Object member) throws SettingsException {
        if (member == null) {
            throw new SettingsException();
        }
    }

    Settings(ConnectionSettingsBuilderComponent c, SessionSettingsBuilderComponent s) {
        this.settingsId = s.settingsId;
        this.dataDigest = c.dataDigest;
        this.headerDigest = c.headerDigest;
        this.ifMarker = c.ifMarker;
        this.ifMarkInt = c.ifMarkInt;
        this.maxRecvDataSegmentLength = c.maxRecvDataSegmentLength;
        this.ofMarker = c.ofMarker;
        this.ofMarkInt = c.ofMarkInt;
        this.targetName = c.targetName;
        this.dataPduInOrder = s.dataPduInOrder;
        this.dataSequenceInOrder = s.dataSequenceInOrder;
        this.defaultTime2Retain = s.defaultTime2Retain;
        this.defaultTime2Wait = s.defaultTime2Wait;
        this.errorRecoveryLevel = s.errorRecoveryLevel;
        this.firstBurstLength = s.firstBurstLength;
        this.immediateData = s.immediateData;
        this.initialR2T = s.initialR2T;
        this.initiatorAlias = s.initiatorAlias;
        this.initiatorName = s.initiatorName;
        this.maxBurstLength = s.maxBurstLength;
        this.maxConnections = s.maxConnections;
        this.maxOutstandingR2T = s.maxOutstandingR2T;
        this.sessionType = s.sessionType;
    }

    long getSettingsId() {
        return this.settingsId;
    }

    public String getDataDigest() throws SettingsException {
        Settings.checkIfNull(this.dataDigest);
        return this.dataDigest;
    }

    public String getHeaderDigest() throws SettingsException {
        Settings.checkIfNull(this.headerDigest);
        return this.headerDigest;
    }

    public boolean getIfMarker() throws SettingsException {
        Settings.checkIfNull(this.ifMarker);
        return this.ifMarker;
    }

    public int getIfMarkInt() throws SettingsException {
        Settings.checkIfNull(this.ifMarkInt);
        return this.ifMarkInt;
    }

    public int getMaxRecvDataSegmentLength() throws SettingsException {
        Settings.checkIfNull(this.maxRecvDataSegmentLength);
        return this.maxRecvDataSegmentLength;
    }

    public boolean getOfMarker() throws SettingsException {
        Settings.checkIfNull(this.ofMarker);
        return this.ofMarker;
    }

    public int getOfMarkInt() throws SettingsException {
        Settings.checkIfNull(this.ofMarkInt);
        return this.ofMarkInt;
    }

    public boolean getDataPduInOrder() throws SettingsException {
        Settings.checkIfNull(this.dataPduInOrder);
        return this.dataPduInOrder;
    }

    public boolean getDataSequenceInOrder() throws SettingsException {
        Settings.checkIfNull(this.dataSequenceInOrder);
        return this.dataSequenceInOrder;
    }

    public int getErrorRecoveryLevel() throws SettingsException {
        Settings.checkIfNull(this.errorRecoveryLevel);
        return this.errorRecoveryLevel;
    }

    public int getDefaultTime2Retain() throws SettingsException {
        Settings.checkIfNull(this.defaultTime2Retain);
        return this.defaultTime2Retain;
    }

    public int getDefaultTime2Wait() throws SettingsException {
        Settings.checkIfNull(this.defaultTime2Wait);
        return this.defaultTime2Wait;
    }

    public int getFirstBurstLength() throws SettingsException {
        Settings.checkIfNull(this.firstBurstLength);
        return this.firstBurstLength;
    }

    public boolean getImmediateData() throws SettingsException {
        Settings.checkIfNull(this.immediateData);
        return this.immediateData;
    }

    public boolean getInitialR2T() throws SettingsException {
        Settings.checkIfNull(this.initialR2T);
        return this.initialR2T;
    }

    public String getInitiatorAlias() throws SettingsException {
        Settings.checkIfNull(this.initiatorAlias);
        return this.initiatorAlias;
    }

    public String getInitiatorName() throws SettingsException {
        Settings.checkIfNull(this.initiatorName);
        return this.initiatorName;
    }

    public int getMaxBurstLength() throws SettingsException {
        Settings.checkIfNull(this.maxBurstLength);
        return this.maxBurstLength;
    }

    public int getMaxConnections() throws SettingsException {
        Settings.checkIfNull(this.maxConnections);
        return this.maxConnections;
    }

    public int getMaxOutstandingR2T() throws SettingsException {
        Settings.checkIfNull(this.maxOutstandingR2T);
        return this.maxOutstandingR2T;
    }

    public String getSessionType() throws SettingsException {
        Settings.checkIfNull(this.maxOutstandingR2T);
        return this.sessionType;
    }

    public String getTargetName() throws SettingsException {
        return this.targetName;
    }
}

