/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.target.settings;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jscsi.target.settings.entry.Entry;

public abstract class SettingsNegotiator {
    protected List<Entry> entries = new ArrayList<Entry>();
    protected List<Entry> backUpEntries;

    static final Entry getEntry(String key, Collection<Entry> entries) {
        for (Entry e : entries) {
            if (!e.matchKey(key)) continue;
            return e;
        }
        return null;
    }

    protected static final List<Entry> copy(List<Entry> entries) {
        if (entries == null) {
            return null;
        }
        ArrayList<Entry> copy = new ArrayList<Entry>();
        for (Entry e : entries) {
            copy.add(e.copy());
        }
        return copy;
    }

    public SettingsNegotiator() {
        this.initializeEntries();
    }

    protected final void backUpEntries() {
        this.backUpEntries = SettingsNegotiator.copy(this.entries);
    }

    protected final void commitOrRollBackChanges(boolean commitChanges) {
        if (commitChanges) {
            for (Entry e : this.entries) {
                e.resetAlreadyNegotiated();
            }
        } else {
            this.entries = this.backUpEntries;
        }
        this.backUpEntries = null;
    }

    protected abstract void initializeEntries();

    public abstract boolean checkConstraints();
}

